/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RegisteredServiceMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceMultifactorAuthenticationPolicyEventResolver.class);

    public RegisteredServiceMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authSelectionStrategies, MultifactorAuthenticationProviderSelector selector) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authSelectionStrategies, selector);
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        RegisteredServiceMultifactorPolicy policy = service.getMultifactorPolicy();
        if (policy == null || policy.getMultifactorAuthenticationProviders().isEmpty()) {
            LOGGER.debug("Authentication policy does not contain any multifactor authentication providers");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)policy.getPrincipalAttributeNameTrigger()) || StringUtils.isNotBlank((CharSequence)policy.getPrincipalAttributeValueToMatch())) {
            LOGGER.debug("Authentication policy for [{}] has defined principal attribute triggers. Skipping...", (Object)service.getServiceId());
            return null;
        }
        return this.resolveEventPerAuthenticationProvider(authentication.getPrincipal(), context, service);
    }

    protected Set<Event> resolveEventPerAuthenticationProvider(Principal principal, RequestContext context, RegisteredService service) {
        Collection<MultifactorAuthenticationProvider> providers = this.flattenProviders(this.getAuthenticationProviderForService(service));
        if (providers != null && !providers.isEmpty()) {
            MultifactorAuthenticationProvider provider = this.multifactorAuthenticationProviderSelector.resolve(providers, service, principal);
            LOGGER.debug("Selected multifactor authentication provider for this transaction is [{}]", (Object)provider);
            if (!provider.isAvailable(service)) {
                LOGGER.warn("Multifactor authentication provider [{}] could not be verified/reached.", (Object)provider);
                return null;
            }
            String identifier = provider.getId();
            LOGGER.debug("Attempting to build an event based on the authentication provider [{}] and service [{}]", (Object)provider, (Object)service.getName());
            Event event = this.validateEventIdForMatchingTransitionInContext(identifier, context, RegisteredServiceMultifactorAuthenticationPolicyEventResolver.buildEventAttributeMap(principal, service, provider));
            return CollectionUtils.wrapSet((Object)event);
        }
        LOGGER.debug("No multifactor authentication providers could be located for [{}]", (Object)service);
        return null;
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

