/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SelectiveAuthenticationProviderWebflowEventEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectiveAuthenticationProviderWebflowEventEventResolver.class);

    public SelectiveAuthenticationProviderWebflowEventEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        Set<Event> resolvedEvents = this.getResolvedEventsAsAttribute(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        RegisteredService registeredService = this.resolveRegisteredServiceInRequestContext(context);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        return this.resolveEventsInternal(resolvedEvents, authentication, registeredService, request, context);
    }

    protected Set<Event> resolveEventsInternal(Set<Event> resolveEvents, Authentication authentication, RegisteredService registeredService, HttpServletRequest request, RequestContext context) {
        if (!resolveEvents.isEmpty()) {
            LOGGER.debug("Collection of resolved events for this authentication sequence are:");
            resolveEvents.forEach(e -> LOGGER.debug("Event id [{}] resolved from [{}]", (Object)e.getId(), (Object)e.getSource().getClass().getName()));
        } else {
            LOGGER.debug("No events could be resolved for this authentication transaction [{}] and service [{}]", (Object)authentication, (Object)registeredService);
        }
        Pair<Set<Event>, Collection<MultifactorAuthenticationProvider>> pair = this.filterEventsByMultifactorAuthenticationProvider(resolveEvents, authentication, registeredService, request);
        WebUtils.putResolvedMultifactorAuthenticationProviders((RequestContext)context, (Collection)((Collection)pair.getValue()));
        return (Set)pair.getKey();
    }

    protected Pair<Set<Event>, Collection<MultifactorAuthenticationProvider>> filterEventsByMultifactorAuthenticationProvider(Set<Event> resolveEvents, Authentication authentication, RegisteredService registeredService, HttpServletRequest request) {
        LOGGER.debug("Locating multifactor providers to determine support for this authentication sequence");
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providers == null || providers.isEmpty()) {
            LOGGER.debug("No providers are available to honor this request. Moving on...");
            return Pair.of(resolveEvents, new HashSet(0));
        }
        Collection<MultifactorAuthenticationProvider> flattenedProviders = this.flattenProviders(providers.values());
        flattenedProviders.removeIf(p -> resolveEvents.stream().filter(e -> p.supports(e, authentication, registeredService, request)).count() == 0L);
        resolveEvents.removeIf(e -> flattenedProviders.stream().filter(p -> p.supports(e, authentication, registeredService, request)).count() == 0L);
        LOGGER.debug("Finalized set of resolved events are [{}]", resolveEvents);
        return Pair.of(resolveEvents, flattenedProviders);
    }
}

