/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitialAuthenticationAttemptWebflowEventResolver
extends AbstractCasWebflowEventResolver
implements CasDelegatingWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialAuthenticationAttemptWebflowEventResolver.class);
    private final List<CasWebflowEventResolver> orderedResolvers = new ArrayList<CasWebflowEventResolver>();
    private CasWebflowEventResolver selectiveResolver;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public InitialAuthenticationAttemptWebflowEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        try {
            AuthenticationResultBuilder builder;
            Credential credential = this.getCredentialFromContext(context);
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            if (credential != null && (builder = this.authenticationSystemSupport.handleInitialAuthenticationTransaction((Service)service, new Credential[]{credential})).getInitialAuthentication().isPresent()) {
                WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
                WebUtils.putAuthentication((Authentication)((Authentication)builder.getInitialAuthentication().get()), (RequestContext)context);
            }
            RegisteredService registeredService = this.determineRegisteredServiceForEvent(context, (Service)service);
            LOGGER.debug("Attempting to resolve candidate authentication events for service [{}]", (Object)service);
            Set<Event> resolvedEvents = this.resolveCandidateAuthenticationEvents(context, (Service)service, registeredService);
            if (!resolvedEvents.isEmpty()) {
                LOGGER.debug("The set of authentication events resolved for [{}] are [{}]. Beginning to select the final event...", (Object)service, resolvedEvents);
                this.putResolvedEventsAsAttribute(context, resolvedEvents);
                Event finalResolvedEvent = this.selectiveResolver.resolveSingle(context);
                LOGGER.debug("The final authentication event resolved for [{}] is [{}]", (Object)service, (Object)finalResolvedEvent);
                if (finalResolvedEvent != null) {
                    return CollectionUtils.wrapSet((Object)finalResolvedEvent);
                }
            } else {
                LOGGER.debug("No candidate authentication events were resolved for service [{}]", (Object)service);
            }
            AuthenticationResultBuilder builder2 = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
            if (builder2 == null) {
                throw new IllegalArgumentException("No authentication result builder can be located in the context");
            }
            return CollectionUtils.wrapSet((Object)this.grantTicketGrantingTicketToAuthenticationResult(context, builder2, (Service)service));
        }
        catch (Exception e) {
            Event event = this.returnAuthenticationExceptionEventIfNeeded(e);
            if (event == null) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                event = this.newEvent("error", e);
            }
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return CollectionUtils.wrapSet((Object)event);
        }
    }

    private RegisteredService determineRegisteredServiceForEvent(RequestContext context, Service service) {
        RegisteredService registeredService = null;
        if (service != null) {
            LOGGER.debug("Locating service [{}] in service registry to determine authentication policy", (Object)service);
            registeredService = this.servicesManager.findServiceBy(service);
            LOGGER.debug("Locating authentication event in the request context...");
            Authentication authn = WebUtils.getAuthentication((RequestContext)context);
            LOGGER.debug("Enforcing access strategy policies for registered service [{}] and principal [{}]", (Object)registeredService, (Object)authn.getPrincipal());
            URI unauthorizedRedirectUrl = registeredService.getAccessStrategy().getUnauthorizedRedirectUrl();
            if (unauthorizedRedirectUrl != null) {
                WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)unauthorizedRedirectUrl);
            }
            AuditableContext audit = AuditableContext.builder().service(service).authentication(authn).registeredService(registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.FALSE).build();
            AuditableExecutionResult result = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            result.throwExceptionIfNeeded();
        }
        return registeredService;
    }

    protected Set<Event> resolveCandidateAuthenticationEvents(RequestContext context, Service service, RegisteredService registeredService) {
        Comparator<Event> byEventId = Comparator.comparing(Event::getId);
        Supplier<TreeSet> supplier = () -> new TreeSet(byEventId);
        return this.orderedResolvers.stream().map(resolver -> {
            LOGGER.debug("Resolving candidate authentication event for service [{}] using [{}]", (Object)service, (Object)resolver.getName());
            return resolver.resolveSingle(context);
        }).filter(Objects::nonNull).collect(Collectors.toCollection(supplier));
    }

    @Override
    public void addDelegate(CasWebflowEventResolver r) {
        if (r != null) {
            this.orderedResolvers.add(r);
        }
    }

    @Override
    public void addDelegate(CasWebflowEventResolver r, int index) {
        if (r != null) {
            this.orderedResolvers.add(index, r);
        }
    }

    private Event returnAuthenticationExceptionEventIfNeeded(Exception e) {
        Exception ex;
        if (e instanceof AuthenticationException || e instanceof AbstractTicketException) {
            ex = e;
        } else if (e.getCause() instanceof AuthenticationException || e.getCause() instanceof AbstractTicketException) {
            ex = (Exception)e.getCause();
        } else {
            return null;
        }
        LOGGER.debug(ex.getMessage(), (Throwable)ex);
        return this.newEvent("authenticationFailure", ex);
    }

    @Generated
    public void setSelectiveResolver(CasWebflowEventResolver selectiveResolver) {
        this.selectiveResolver = selectiveResolver;
    }
}

