/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.executor;

import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.model.webapp.WebflowProperties;
import org.apereo.cas.configuration.model.webapp.WebflowSessionManagementProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.web.flow.executor.WebflowCipherBean;
import org.apereo.spring.webflow.plugin.ClientFlowExecutionRepository;
import org.apereo.spring.webflow.plugin.EncryptedTranscoder;
import org.apereo.spring.webflow.plugin.Transcoder;
import org.cryptacular.bean.CipherBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshotFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;

public class WebflowExecutorFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebflowExecutorFactory.class);
    private final WebflowProperties webflowProperties;
    private final FlowDefinitionRegistry flowDefinitionRegistry;
    private final CipherExecutor webflowCipherExecutor;
    private final FlowExecutionListener[] executionListeners;

    public FlowExecutor build() {
        if (this.webflowProperties.getSession().isStorage()) {
            return this.buildFlowExecutorViaServerSessionBindingExecution();
        }
        return this.buildFlowExecutorViaClientFlowExecution();
    }

    private FlowExecutor buildFlowExecutorViaServerSessionBindingExecution() {
        SessionBindingConversationManager conversationManager = new SessionBindingConversationManager();
        WebflowSessionManagementProperties session = this.webflowProperties.getSession();
        conversationManager.setLockTimeoutSeconds((int)Beans.newDuration((String)session.getLockTimeout()).getSeconds());
        conversationManager.setMaxConversations(session.getMaxConversations());
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionListenerLoader((FlowExecutionListenerLoader)new StaticFlowExecutionListenerLoader(this.executionListeners));
        SerializedFlowExecutionSnapshotFactory flowExecutionSnapshotFactory = new SerializedFlowExecutionSnapshotFactory((FlowExecutionFactory)executionFactory, (FlowDefinitionLocator)this.flowDefinitionRegistry);
        flowExecutionSnapshotFactory.setCompress(session.isCompress());
        DefaultFlowExecutionRepository repository = new DefaultFlowExecutionRepository((ConversationManager)conversationManager, (FlowExecutionSnapshotFactory)flowExecutionSnapshotFactory);
        executionFactory.setExecutionKeyFactory((FlowExecutionKeyFactory)repository);
        return new FlowExecutorImpl((FlowDefinitionLocator)this.flowDefinitionRegistry, (FlowExecutionFactory)executionFactory, (FlowExecutionRepository)repository);
    }

    private FlowExecutor buildFlowExecutorViaClientFlowExecution() {
        ClientFlowExecutionRepository repository = new ClientFlowExecutionRepository();
        repository.setFlowDefinitionLocator((FlowDefinitionLocator)this.flowDefinitionRegistry);
        repository.setTranscoder(this.getWebflowStateTranscoder());
        FlowExecutionImplFactory factory = new FlowExecutionImplFactory();
        factory.setExecutionKeyFactory((FlowExecutionKeyFactory)repository);
        factory.setExecutionListenerLoader((FlowExecutionListenerLoader)new StaticFlowExecutionListenerLoader(new FlowExecutionListener[0]));
        repository.setFlowExecutionFactory((FlowExecutionFactory)factory);
        factory.setExecutionListenerLoader((FlowExecutionListenerLoader)new StaticFlowExecutionListenerLoader(this.executionListeners));
        return new FlowExecutorImpl((FlowDefinitionLocator)this.flowDefinitionRegistry, (FlowExecutionFactory)factory, (FlowExecutionRepository)repository);
    }

    private Transcoder getWebflowStateTranscoder() {
        WebflowCipherBean cipherBean = new WebflowCipherBean(this.webflowCipherExecutor);
        return new EncryptedTranscoder((CipherBean)cipherBean);
    }

    @Generated
    public WebflowExecutorFactory(WebflowProperties webflowProperties, FlowDefinitionRegistry flowDefinitionRegistry, CipherExecutor webflowCipherExecutor, FlowExecutionListener[] executionListeners) {
        this.webflowProperties = webflowProperties;
        this.flowDefinitionRegistry = flowDefinitionRegistry;
        this.webflowCipherExecutor = webflowCipherExecutor;
        this.executionListeners = executionListeners;
    }
}

