/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.Arrays;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.Action;

public abstract class AbstractMultifactorTrustedDeviceWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMultifactorTrustedDeviceWebflowConfigurer.class);
    public static final String MFA_TRUSTED_AUTHN_SCOPE_ATTR = "mfaTrustedAuthentication";
    private static final String MFA_VERIFY_TRUST_ACTION_BEAN_ID = "mfaVerifyTrustAction";
    private static final String MFA_SET_TRUST_ACTION_BEAN_ID = "mfaSetTrustAction";
    private final boolean enableDeviceRegistration;

    public AbstractMultifactorTrustedDeviceWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, boolean enableDeviceRegistration, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.enableDeviceRegistration = enableDeviceRegistration;
    }

    protected void registerMultifactorTrustedAuthentication(FlowDefinitionRegistry flowDefinitionRegistry) {
        this.validateFlowDefinitionConfiguration(flowDefinitionRegistry);
        LOGGER.debug("Flow definitions found in the registry are [{}]", (Object[])flowDefinitionRegistry.getFlowDefinitionIds());
        String flowId = Arrays.stream(flowDefinitionRegistry.getFlowDefinitionIds()).findFirst().get();
        LOGGER.debug("Processing flow definition [{}]", (Object)flowId);
        Flow flow = (Flow)flowDefinitionRegistry.getFlowDefinition(flowId);
        ActionState state = this.getState(flow, "initializeLoginForm", ActionState.class);
        Transition transition = (Transition)state.getTransition("success");
        String targetStateId = transition.getTargetStateId();
        transition.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("verifyTrustedDevice"));
        ActionState verifyAction = this.createActionState(flow, "verifyTrustedDevice", (Action)this.createEvaluateAction(MFA_VERIFY_TRUST_ACTION_BEAN_ID));
        if (this.enableDeviceRegistration) {
            this.createTransitionForState((TransitionableState)verifyAction, "yes", "finishMfaTrustedAuth");
        } else {
            this.createTransitionForState((TransitionableState)verifyAction, "yes", "realSubmit");
        }
        this.createTransitionForState((TransitionableState)verifyAction, "no", targetStateId);
        this.createDecisionState(flow, "checkRegistrationRequired", AbstractMultifactorTrustedDeviceWebflowConfigurer.isDeviceRegistrationRequired(), "registerDeviceView", "realSubmit");
        ActionState submit = this.getState(flow, "realSubmit", ActionState.class);
        Transition success = (Transition)submit.getTransition("success");
        if (this.enableDeviceRegistration) {
            success.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("registerDeviceView"));
        } else {
            success.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("registerTrustedDevice"));
        }
        ViewState viewRegister = this.createViewState(flow, "registerDeviceView", "casMfaRegisterDeviceView");
        Transition viewRegisterTransition = this.createTransition("submit", "registerTrustedDevice");
        viewRegister.getTransitionSet().add(viewRegisterTransition);
        ActionState registerAction = this.createActionState(flow, "registerTrustedDevice", (Action)this.createEvaluateAction(MFA_SET_TRUST_ACTION_BEAN_ID));
        this.createStateDefaultTransition((TransitionableState)registerAction, "success");
        if (submit.getActionList().size() == 0) {
            throw new IllegalArgumentException("There are no actions defined for the final submission event of " + flowId);
        }
        Action act = (Action)submit.getActionList().iterator().next();
        ActionState finishMfaTrustedAuth = this.createActionState(flow, "finishMfaTrustedAuth", act);
        Transition finishedTransition = this.createTransition("success", "success");
        finishMfaTrustedAuth.getTransitionSet().add(finishedTransition);
        this.createStateDefaultTransition((TransitionableState)finishMfaTrustedAuth, "success");
    }

    private void validateFlowDefinitionConfiguration(FlowDefinitionRegistry flowDefinitionRegistry) {
        if (flowDefinitionRegistry.getFlowDefinitionCount() <= 0) {
            throw new IllegalArgumentException("Flow definition registry has no flow definitions");
        }
        String msg = "CAS application context cannot find bean [%s]. This typically indicates that configuration is attempting to activate trusted-devices functionality for multifactor authentication, yet the configuration modules that auto-configure the webflow are absent from the CAS application runtime. If you have no need for trusted-devices functionality and wish to let the multifactor authentication provider (and not CAS) remember and record trusted devices for you, you need to turn this behavior off.";
        if (!this.applicationContext.containsBean(MFA_SET_TRUST_ACTION_BEAN_ID)) {
            throw new IllegalArgumentException(String.format("CAS application context cannot find bean [%s]. This typically indicates that configuration is attempting to activate trusted-devices functionality for multifactor authentication, yet the configuration modules that auto-configure the webflow are absent from the CAS application runtime. If you have no need for trusted-devices functionality and wish to let the multifactor authentication provider (and not CAS) remember and record trusted devices for you, you need to turn this behavior off.", MFA_SET_TRUST_ACTION_BEAN_ID));
        }
        if (!this.applicationContext.containsBean(MFA_VERIFY_TRUST_ACTION_BEAN_ID)) {
            throw new IllegalArgumentException(String.format("CAS application context cannot find bean [%s]. This typically indicates that configuration is attempting to activate trusted-devices functionality for multifactor authentication, yet the configuration modules that auto-configure the webflow are absent from the CAS application runtime. If you have no need for trusted-devices functionality and wish to let the multifactor authentication provider (and not CAS) remember and record trusted devices for you, you need to turn this behavior off.", MFA_VERIFY_TRUST_ACTION_BEAN_ID));
        }
    }

    private static String isDeviceRegistrationRequired() {
        return "flashScope.".concat(MFA_TRUSTED_AUTHN_SCOPE_ATTR).concat("== null");
    }
}

