/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

public abstract class AbstractCasMultifactorWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasMultifactorWebflowConfigurer.class);

    public AbstractCasMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
    }

    protected void registerMultifactorFlowDefinitionIntoLoginFlowRegistry(FlowDefinitionRegistry sourceRegistry) {
        String[] flowIds;
        for (String flowId : flowIds = sourceRegistry.getFlowDefinitionIds()) {
            FlowDefinition definition = sourceRegistry.getFlowDefinition(flowId);
            LOGGER.debug("Registering flow definition [{}]", (Object)flowId);
            this.loginFlowDefinitionRegistry.registerFlowDefinition(definition);
        }
    }

    private void ensureEndStateTransitionExists(TransitionableState state, Flow mfaProviderFlow, String transId, String stateId) {
        if (!this.containsTransition(state, transId)) {
            this.createTransitionForState(state, transId, stateId);
            if (!this.containsFlowState(mfaProviderFlow, stateId)) {
                this.createEndState(mfaProviderFlow, stateId);
            }
        }
    }

    protected void augmentMultifactorProviderFlowRegistry(FlowDefinitionRegistry mfaProviderFlowRegistry) {
        String[] flowIds = mfaProviderFlowRegistry.getFlowDefinitionIds();
        Arrays.stream(flowIds).forEach(id -> {
            Flow flow = (Flow)Flow.class.cast(mfaProviderFlowRegistry.getFlowDefinition(id));
            if (this.containsFlowState(flow, "realSubmit")) {
                Collection<String> states = this.getCandidateStatesForMultifactorAuthentication();
                states.forEach(s -> {
                    TransitionableState state = this.getState(flow, (String)s);
                    this.ensureEndStateTransitionExists(state, flow, "success", "success");
                    this.ensureEndStateTransitionExists(state, flow, "successWithWarnings", "successWithWarnings");
                });
            }
        });
    }

    protected void registerMultifactorProviderAuthenticationWebflow(Flow flow, String subflowId, FlowDefinitionRegistry mfaProviderFlowRegistry) {
        SubflowState subflowState = this.createSubflowState(flow, subflowId, subflowId);
        Collection<String> states = this.getCandidateStatesForMultifactorAuthentication();
        LOGGER.debug("Candidate states for multifactor authentication are [{}]", states);
        states.forEach(s -> {
            LOGGER.debug("Locating state [{}] to process for multifactor authentication", s);
            TransitionableState actionState = this.getState(flow, (String)s);
            LOGGER.debug("Locating transition id [{}] to process multifactor authentication for state [{}", (Object)"success", s);
            String targetSuccessId = actionState.getTransition("success").getTargetStateId();
            LOGGER.debug("Locating transition id [{}] to process multifactor authentication for state [{}", (Object)"successWithWarnings", s);
            String targetWarningsId = actionState.getTransition("successWithWarnings").getTargetStateId();
            ArrayList<DefaultMapping> mappings = new ArrayList<DefaultMapping>();
            Mapper inputMapper = this.createMapperToSubflowState(mappings);
            SubflowAttributeMapper subflowMapper = this.createSubflowAttributeMapper(inputMapper, null);
            subflowState.setAttributeMapper(subflowMapper);
            LOGGER.debug("Creating transitions to subflow state [{}]", (Object)subflowState.getId());
            TransitionSet transitionSet = subflowState.getTransitionSet();
            transitionSet.add(this.createTransition("success", targetSuccessId));
            transitionSet.add(this.createTransition("successWithWarnings", targetWarningsId));
            LOGGER.debug("Creating transition [{}] for state [{}]", (Object)subflowId, (Object)actionState.getId());
            this.createTransitionForState(actionState, subflowId, subflowId);
            this.registerMultifactorFlowDefinitionIntoLoginFlowRegistry(mfaProviderFlowRegistry);
            this.augmentMultifactorProviderFlowRegistry(mfaProviderFlowRegistry);
            TransitionableState state = this.getTransitionableState(flow, "initialAuthenticationRequestValidationCheck");
            this.createTransitionForState(state, subflowId, subflowId);
        });
    }

    protected Collection<String> getCandidateStatesForMultifactorAuthentication() {
        return CollectionUtils.wrapSet((Object)"realSubmit");
    }
}

