/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DefaultSingleSignOnParticipationStrategy
implements SingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleSignOnParticipationStrategy.class);
    private final ServicesManager servicesManager;
    private boolean createSsoSessionCookieOnRenewAuthentications = true;
    private boolean renewEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParticipating(RequestContext ctx) {
        RegisteredService registeredService;
        if (this.renewEnabled && ctx.getRequestParameters().contains("renew")) {
            LOGGER.debug("[{}] is specified for the request. The authentication session will be considered renewed.", (Object)"renew");
            return this.createSsoSessionCookieOnRenewAuthentications;
        }
        Authentication authentication = WebUtils.getAuthentication((RequestContext)ctx);
        WebApplicationService service = WebUtils.getService((RequestContext)ctx);
        if (service != null && (registeredService = this.servicesManager.findServiceBy((Service)service)) != null) {
            Authentication ca = AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication();
            try {
                AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
                boolean isAllowedForSso = registeredService.getAccessStrategy().isServiceAccessAllowedForSso();
                LOGGER.debug("Located [{}] in registry. Service access to participate in SSO is set to [{}]", (Object)registeredService.getServiceId(), (Object)isAllowedForSso);
                boolean bl = isAllowedForSso;
                return bl;
            }
            finally {
                AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)ca);
            }
        }
        return true;
    }

    @Generated
    public DefaultSingleSignOnParticipationStrategy(ServicesManager servicesManager, boolean createSsoSessionCookieOnRenewAuthentications, boolean renewEnabled) {
        this.servicesManager = servicesManager;
        this.createSsoSessionCookieOnRenewAuthentications = createSsoSessionCookieOnRenewAuthentications;
        this.renewEnabled = renewEnabled;
    }
}

