/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;

public class ThemeFileTemplateResolver
extends FileTemplateResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeFileTemplateResolver.class);
    protected final CasConfigurationProperties casProperties;

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        String themeName = this.getCurrentTheme();
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            String themeTemplate = String.format(resourceName, themeName);
            return super.computeTemplateResource(configuration, ownerTemplate, template, themeTemplate, characterEncoding, templateResolutionAttributes);
        }
        return super.computeTemplateResource(configuration, ownerTemplate, template, resourceName, characterEncoding, templateResolutionAttributes);
    }

    protected String getCurrentTheme() {
        HttpSession session;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        if (request != null && (session = request.getSession(false)) != null) {
            return (String)session.getAttribute(this.casProperties.getTheme().getParamName());
        }
        return null;
    }

    @Generated
    public ThemeFileTemplateResolver(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

