/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.view.ViewProperties;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.view.ThemeFileTemplateResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class RestfulUrlTemplateResolver
extends ThemeFileTemplateResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulUrlTemplateResolver.class);

    public RestfulUrlTemplateResolver(CasConfigurationProperties casProperties) {
        super(casProperties);
    }

    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        HttpServletRequest request;
        ViewProperties.Rest rest = this.casProperties.getView().getRest();
        String themeName = this.getCurrentTheme();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("owner", ownerTemplate);
        headers.put("template", template);
        headers.put("resource", resourceName);
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            headers.put("theme", themeName);
        }
        if ((request = WebUtils.getHttpServletRequestFromExternalWebflowContext()) != null) {
            headers.put("locale", request.getLocale().getCountry());
            headers.putAll(HttpRequestUtils.getRequestHeaders((HttpServletRequest)request));
        }
        try {
            HttpResponse response = HttpUtils.execute((String)rest.getUrl(), (String)rest.getMethod(), (String)rest.getBasicAuthUsername(), (String)rest.getBasicAuthPassword(), headers);
            int statusCode = response.getStatusLine().getStatusCode();
            if (response != null && HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                return new StringTemplateResource(result);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return super.computeTemplateResource(configuration, ownerTemplate, template, resourceName, characterEncoding, templateResolutionAttributes);
    }
}

