/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.support;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.security.ResponseHeadersEnforcementFilter;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceResponseHeadersEnforcementFilter
extends ResponseHeadersEnforcementFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceResponseHeadersEnforcementFilter.class);
    private final ServicesManager servicesManager;
    private final ArgumentExtractor argumentExtractor;

    protected void decideInsertContentSecurityPolicyHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (this.shouldHttpHeaderBeInjectedIntoResponse(httpServletRequest, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_CONTENT_SECURITY_POLICY)) {
            super.insertContentSecurityPolicyHeader(httpServletResponse, httpServletRequest);
        } else {
            super.decideInsertContentSecurityPolicyHeader(httpServletResponse, httpServletRequest);
        }
    }

    protected void decideInsertXSSProtectionHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (this.shouldHttpHeaderBeInjectedIntoResponse(httpServletRequest, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_XSS_PROTECTION)) {
            super.insertXSSProtectionHeader(httpServletResponse, httpServletRequest);
        } else {
            super.decideInsertXSSProtectionHeader(httpServletResponse, httpServletRequest);
        }
    }

    protected void decideInsertXFrameOptionsHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (this.shouldHttpHeaderBeInjectedIntoResponse(httpServletRequest, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_XFRAME_OPTIONS)) {
            super.insertXFrameOptionsHeader(httpServletResponse, httpServletRequest);
        } else {
            super.decideInsertXFrameOptionsHeader(httpServletResponse, httpServletRequest);
        }
    }

    protected void decideInsertXContentTypeOptionsHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (this.shouldHttpHeaderBeInjectedIntoResponse(httpServletRequest, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_XCONTENT_OPTIONS)) {
            super.insertXContentTypeOptionsHeader(httpServletResponse, httpServletRequest);
        } else {
            super.decideInsertXContentTypeOptionsHeader(httpServletResponse, httpServletRequest);
        }
    }

    protected void decideInsertCacheControlHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (this.shouldHttpHeaderBeInjectedIntoResponse(httpServletRequest, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_CACHE_CONTROL)) {
            super.insertCacheControlHeader(httpServletResponse, httpServletRequest);
        } else {
            super.decideInsertCacheControlHeader(httpServletResponse, httpServletRequest);
        }
    }

    protected void decideInsertStrictTransportSecurityHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (this.shouldHttpHeaderBeInjectedIntoResponse(httpServletRequest, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_STRICT_TRANSPORT_SECURITY)) {
            super.insertStrictTransportSecurityHeader(httpServletResponse, httpServletRequest);
        } else {
            super.decideInsertStrictTransportSecurityHeader(httpServletResponse, httpServletRequest);
        }
    }

    private boolean shouldHttpHeaderBeInjectedIntoResponse(HttpServletRequest request, RegisteredServiceProperty.RegisteredServiceProperties property) {
        Map properties;
        Optional<RegisteredService> result = this.getRegisteredServiceFromRequest(request);
        if (result.isPresent() && (properties = result.get().getProperties()).containsKey(property.getPropertyName())) {
            RegisteredServiceProperty prop = (RegisteredServiceProperty)properties.get(property.getPropertyName());
            return BooleanUtils.toBoolean((String)prop.getValue());
        }
        return false;
    }

    private Optional<RegisteredService> getRegisteredServiceFromRequest(HttpServletRequest request) {
        WebApplicationService service = this.argumentExtractor.extractService(request);
        if (service != null) {
            return Optional.ofNullable(this.servicesManager.findServiceBy((Service)service));
        }
        return Optional.empty();
    }

    @Generated
    public RegisteredServiceResponseHeadersEnforcementFilter(ServicesManager servicesManager, ArgumentExtractor argumentExtractor) {
        this.servicesManager = servicesManager;
        this.argumentExtractor = argumentExtractor;
    }
}

