/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationUtils.class);

    public static byte[] serialize(Serializable object) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        SerializationUtils.serialize(object, outBytes);
        return outBytes.toByteArray();
    }

    public static void serialize(Serializable object, OutputStream outputStream) {
        try (ObjectOutputStream out = new ObjectOutputStream(outputStream);){
            out.writeObject(object);
        }
    }

    public static <T> T deserialize(byte[] inBytes, Class<T> clazz) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inBytes);
        return SerializationUtils.deserialize(inputStream, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream, Class<T> clazz) {
        try (ObjectInputStream in = new ObjectInputStream(inputStream);){
            Object obj = in.readObject();
            if (!clazz.isAssignableFrom(obj.getClass())) {
                throw new ClassCastException("Result [" + obj + " is of type " + obj.getClass() + " when we were expecting " + clazz);
            }
            Object object = obj;
            return (T)object;
        }
    }

    public static byte[] serializeAndEncodeObject(CipherExecutor cipher, Serializable object, Object[] parameters) {
        byte[] outBytes = SerializationUtils.serialize(object);
        return (byte[])cipher.encode((Object)outBytes, parameters);
    }

    public static byte[] serializeAndEncodeObject(CipherExecutor cipher, Serializable object) {
        return SerializationUtils.serializeAndEncodeObject(cipher, object, new Object[0]);
    }

    public static <T extends Serializable> T decodeAndDeserializeObject(byte[] object, CipherExecutor cipher, Class<T> type, Object[] parameters) {
        byte[] decoded = (byte[])cipher.decode((Object)object, parameters);
        return SerializationUtils.deserializeAndCheckObject(decoded, type);
    }

    public static <T extends Serializable> T decodeAndDeserializeObject(byte[] object, CipherExecutor cipher, Class<T> type) {
        return SerializationUtils.decodeAndDeserializeObject(object, cipher, type, new Object[0]);
    }

    public static <T extends Serializable> T deserializeAndCheckObject(byte[] object, Class<T> type) {
        T result = SerializationUtils.deserialize(object, type);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Decoded object is of type " + result.getClass() + " when we were expecting " + type);
        }
        return (T)((Serializable)result);
    }

    @Generated
    private SerializationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

