/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import java.io.Closeable;
import java.io.File;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathWatcherService
implements Runnable,
Closeable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PathWatcherService.class);
    private static final WatchEvent.Kind[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private Thread thread;
    private final WatchService watcher;
    private final Consumer<File> onCreate;
    private final Consumer<File> onModify;
    private final Consumer<File> onDelete;

    public PathWatcherService(File watchablePath, Consumer<File> onModify) {
        this(watchablePath.toPath(), file -> {}, onModify, file -> {});
    }

    public PathWatcherService(Path watchablePath, Consumer<File> onCreate, Consumer<File> onModify, Consumer<File> onDelete) {
        this.onCreate = onCreate;
        this.onModify = onModify;
        this.onDelete = onDelete;
        this.watcher = watchablePath.getFileSystem().newWatchService();
        LOGGER.debug("Created service registry watcher for events of type [{}]", (Object[])KINDS);
        watchablePath.register(this.watcher, KINDS);
    }

    @Override
    public void run() {
        try {
            WatchKey key;
            while ((key = this.watcher.take()) != null) {
                this.handleEvent(key);
                boolean valid = key != null && key.reset();
                if (valid) continue;
                LOGGER.info("Directory key is no longer valid. Quitting watcher service");
            }
        }
        catch (InterruptedException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return;
        }
        catch (ClosedWatchServiceException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return;
        }
    }

    private void handleEvent(WatchKey key) {
        try {
            key.pollEvents().forEach(event -> {
                String eventName = event.kind().name();
                WatchEvent ev = event;
                Path filename = (Path)ev.context();
                Path parent = (Path)key.watchable();
                Path fullPath = parent.resolve(filename);
                File file = fullPath.toFile();
                LOGGER.trace("Detected event [{}] on file [{}]", (Object)eventName, (Object)file);
                if (eventName.equals(StandardWatchEventKinds.ENTRY_CREATE.name()) && file.exists()) {
                    this.onCreate.accept(file);
                } else if (eventName.equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                    this.onDelete.accept(file);
                } else if (eventName.equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) && file.exists()) {
                    this.onModify.accept(file);
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.watcher);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void start(String name) {
        this.thread = new Thread(this);
        this.thread.setName(name);
        this.thread.start();
    }
}

