/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import com.github.axet.wget.SpeedInfo;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.DownloadInfo;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class HttpClientMultiThreadedDownloader {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientMultiThreadedDownloader.class);
    private final Resource resourceToDownload;
    private final File targetDestination;

    public void download() {
        AtomicBoolean stop = new AtomicBoolean(false);
        DownloadInfo info = new DownloadInfo(this.resourceToDownload.getURL());
        DownloadStatusListener status = new DownloadStatusListener(info);
        info.extract(stop, (Runnable)status);
        info.enableMultipart();
        WGet w = new WGet(info, this.targetDestination);
        status.speedInfo.start(0L);
        LOGGER.info("Starting to download resource [{}] into [{}]", (Object)this.resourceToDownload, (Object)this.targetDestination);
        w.download(stop, (Runnable)status);
    }

    @Generated
    public HttpClientMultiThreadedDownloader(Resource resourceToDownload, File targetDestination) {
        this.resourceToDownload = resourceToDownload;
        this.targetDestination = targetDestination;
    }

    private static class DownloadStatusListener
    implements Runnable {
        private final DownloadInfo info;
        private final SpeedInfo speedInfo = new SpeedInfo();
        private long last;

        DownloadStatusListener(DownloadInfo info) {
            this.info = info;
        }

        @Override
        public void run() {
            switch (this.info.getState()) {
                case DONE: {
                    this.speedInfo.end(this.info.getCount());
                    LOGGER.info("Download completed. [{}] average speed ([{}])", (Object)this.info.getState(), (Object)FileUtils.byteCountToDisplaySize((long)this.speedInfo.getAverageSpeed()));
                    break;
                }
                case RETRYING: {
                    LOGGER.debug("[{}] retry: [{}], delay: [{}]", new Object[]{this.info.getState(), this.info.getRetry(), this.info.getDelay()});
                    break;
                }
                case DOWNLOADING: {
                    this.speedInfo.step(this.info.getCount());
                    long now = System.currentTimeMillis();
                    if (now - 1000L <= this.last) break;
                    this.last = now;
                    StringBuilder partBuilder = new StringBuilder();
                    if (this.info.getParts() != null) {
                        this.info.getParts().forEach(p -> {
                            switch (p.getState()) {
                                case DOWNLOADING: {
                                    partBuilder.append(String.format("Part#%d(%.2f) ", p.getNumber(), Float.valueOf((float)p.getCount() / (float)p.getLength())));
                                    break;
                                }
                                case ERROR: 
                                case RETRYING: {
                                    partBuilder.append(String.format("Part#%d(%s) ", p.getNumber(), p.getException().getMessage() + " r:" + p.getRetry() + " d:" + p.getDelay()));
                                    break;
                                }
                            }
                        });
                    }
                    float p2 = (float)this.info.getCount() / (float)this.info.getLength().longValue();
                    LOGGER.debug(String.format("%.2f %s (%s / %s)", Float.valueOf(p2), partBuilder.toString(), FileUtils.byteCountToDisplaySize((long)this.speedInfo.getCurrentSpeed()), FileUtils.byteCountToDisplaySize((long)this.speedInfo.getAverageSpeed())));
                    break;
                }
                default: {
                    LOGGER.debug(this.info.getState().toString());
                }
            }
        }
    }
}

