/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.util.DateTimeUtils;
import org.cryptacular.util.CertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;

public final class CertUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CertUtils.class);
    public static final String X509_CERTIFICATE_TYPE = "X509";

    public static boolean isExpired(X509CRL crl) {
        return CertUtils.isExpired(crl, ZonedDateTime.now(ZoneOffset.UTC));
    }

    public static boolean isExpired(X509CRL crl, ZonedDateTime reference) {
        return reference.isAfter(DateTimeUtils.zonedDateTimeOf(crl.getNextUpdate()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate readCertificate(InputStreamSource resource) {
        try (InputStream in = resource.getInputStream();){
            X509Certificate x509Certificate = CertUtil.readCertificate((InputStream)in);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading certificate " + resource, e);
        }
    }

    public static X509Certificate readCertificate(InputStream resource) {
        return CertUtils.readCertificate((InputStreamSource)new InputStreamResource(resource));
    }

    public static String toString(X509Certificate cert) {
        return new ToStringBuilder((Object)cert, ToStringStyle.NO_CLASS_NAME_STYLE).append("subjectDn", (Object)cert.getSubjectDN()).append("serialNumber", (Object)cert.getSerialNumber()).build();
    }

    public static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("X509 certificate type not supported by default provider.", e);
        }
    }

    @Generated
    private CertUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

