/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStringCipherExecutor
extends AbstractCipherExecutor<Serializable, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStringCipherExecutor.class);
    private static final int ENCRYPTION_KEY_SIZE = 256;
    private static final int SIGNING_KEY_SIZE = 512;
    private String encryptionAlgorithm = "dir";
    private String contentEncryptionAlgorithmIdentifier;
    private Key secretKeyEncryptionKey;
    private boolean encryptionEnabled = true;
    private boolean signingEnabled = true;

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, boolean encryptionEnabled, boolean signingEnabled) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256", encryptionEnabled, signingEnabled);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, boolean encryptionEnabled) {
        this(secretKeyEncryption, secretKeySigning, encryptionEnabled, true);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, String alg) {
        this(secretKeyEncryption, secretKeySigning, alg, true, true);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256", true, true);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier, boolean encryptionEnabled, boolean signingEnabled) {
        this.encryptionEnabled = encryptionEnabled || StringUtils.isNotBlank((CharSequence)secretKeyEncryption);
        boolean bl = this.signingEnabled = signingEnabled || StringUtils.isNotBlank((CharSequence)secretKeySigning);
        if (this.encryptionEnabled) {
            this.configureEncryptionParameters(secretKeyEncryption, contentEncryptionAlgorithmIdentifier);
        } else {
            LOGGER.warn("Encryption is not enabled for [{}]. The cipher [{}] will only attempt to produce signed objects", (Object)this.getName(), (Object)this.getClass().getSimpleName());
        }
        if (this.signingEnabled) {
            this.configureSigningParameters(secretKeySigning);
        } else {
            LOGGER.warn("Signing is not enabled for [{}]. The cipher [{}] will attempt to produce plain objects", (Object)this.getName(), (Object)this.getClass().getSimpleName());
        }
    }

    private void configureSigningParameters(String secretKeySigning) {
        String signingKeyToUse = secretKeySigning;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            LOGGER.warn("Secret key for signing is not defined for [{}]. CAS will attempt to auto-generate the signing key", (Object)this.getName());
            signingKeyToUse = EncodingUtils.generateJsonWebKey(512);
            LOGGER.warn("Generated signing key [{}] of size [{}] for [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{signingKeyToUse, 512, this.getName(), this.getSigningKeySetting()});
        } else {
            LOGGER.debug("Located signing key to use for [{}]", (Object)this.getName());
        }
        this.configureSigningKey(signingKeyToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEncryptionParameters(String secretKeyEncryption, String contentEncryptionAlgorithmIdentifier) {
        String secretKeyToUse = secretKeyEncryption;
        if (StringUtils.isBlank((CharSequence)secretKeyToUse)) {
            LOGGER.warn("Secret key for encryption is not defined for [{}]; CAS will attempt to auto-generate the encryption key", (Object)this.getName());
            secretKeyToUse = EncodingUtils.generateJsonWebKey(256);
            LOGGER.warn("Generated encryption key [{}] of size [{}] for [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{secretKeyToUse, 256, this.getName(), this.getEncryptionKeySetting()});
        } else {
            LOGGER.debug("Located encryption key to use for [{}]", (Object)this.getName());
        }
        try {
            if (ResourceUtils.doesResourceExist(secretKeyToUse)) {
                this.configureEncryptionKeyFromPublicKeyResource(secretKeyToUse);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.secretKeyEncryptionKey == null) {
                LOGGER.debug("Creating encryption key instance based on provided secret key");
                this.setSecretKeyEncryptionKey(EncodingUtils.generateJsonWebKey(secretKeyToUse));
            }
            this.setContentEncryptionAlgorithmIdentifier(contentEncryptionAlgorithmIdentifier);
            LOGGER.debug("Initialized cipher encryption sequence via content encryption [{}] and algorithm [{}]", (Object)this.contentEncryptionAlgorithmIdentifier, (Object)this.encryptionAlgorithm);
        }
    }

    protected void configureEncryptionKeyFromPublicKeyResource(String secretKeyToUse) throws Exception {
        PublicKey object = BaseStringCipherExecutor.extractPublicKeyFromResource(secretKeyToUse);
        LOGGER.debug("Located encryption key resource [{}]", (Object)secretKeyToUse);
        this.setSecretKeyEncryptionKey(object);
        this.setEncryptionAlgorithm("RSA-OAEP-256");
    }

    public String encode(Serializable value, Object[] parameters) {
        String encoded = this.encryptionEnabled && this.secretKeyEncryptionKey != null ? EncodingUtils.encryptValueAsJwt(this.secretKeyEncryptionKey, value, this.encryptionAlgorithm, this.contentEncryptionAlgorithmIdentifier) : value.toString();
        if (this.signingEnabled) {
            byte[] signed = this.sign(encoded.getBytes(StandardCharsets.UTF_8));
            return new String(signed, StandardCharsets.UTF_8);
        }
        return encoded;
    }

    public String decode(Serializable value, Object[] parameters) {
        byte[] encoded;
        byte[] currentValue = value.toString().getBytes(StandardCharsets.UTF_8);
        byte[] byArray = encoded = this.signingEnabled ? this.verifySignature(currentValue) : currentValue;
        if (encoded != null && encoded.length > 0) {
            String encodedObj = new String(encoded, StandardCharsets.UTF_8);
            if (this.encryptionEnabled && this.secretKeyEncryptionKey != null) {
                return EncodingUtils.decryptJwtValue(this.secretKeyEncryptionKey, encodedObj);
            }
            return encodedObj;
        }
        return null;
    }

    protected String getEncryptionKeySetting() {
        return "N/A";
    }

    protected String getSigningKeySetting() {
        return "N/A";
    }

    @Generated
    public BaseStringCipherExecutor() {
    }

    @Generated
    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Generated
    public void setContentEncryptionAlgorithmIdentifier(String contentEncryptionAlgorithmIdentifier) {
        this.contentEncryptionAlgorithmIdentifier = contentEncryptionAlgorithmIdentifier;
    }

    @Generated
    public void setSecretKeyEncryptionKey(Key secretKeyEncryptionKey) {
        this.secretKeyEncryptionKey = secretKeyEncryptionKey;
    }

    @Generated
    public void setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
    }

    @Generated
    public void setSigningEnabled(boolean signingEnabled) {
        this.signingEnabled = signingEnabled;
    }
}

