/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBinaryCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBinaryCipherExecutor.class);
    protected final String cipherName;
    private String secretKeyAlgorithm = "AES";
    private byte[] encryptionSecretKey;
    private final SecretKeySpec encryptionKey;
    private final Cipher aesCipher;

    public BaseBinaryCipherExecutor(String encryptionSecretKey, String signingSecretKey, int signingKeySize, int encryptionKeySize, String cipherName) {
        this.cipherName = cipherName;
        this.ensureSigningKeyExists(signingSecretKey, signingKeySize);
        this.ensureEncryptionKeyExists(encryptionSecretKey, encryptionKeySize);
        this.encryptionKey = new SecretKeySpec(this.encryptionSecretKey, this.secretKeyAlgorithm);
        this.aesCipher = Cipher.getInstance("AES");
    }

    public byte[] encode(byte[] value, Object[] parameters) {
        this.aesCipher.init(1, this.encryptionKey);
        byte[] result = this.aesCipher.doFinal(value);
        return this.sign(result);
    }

    public byte[] decode(byte[] value, Object[] parameters) {
        byte[] verifiedValue = this.verifySignature(value);
        this.aesCipher.init(2, this.encryptionKey);
        byte[] bytePlainText = this.aesCipher.doFinal(verifiedValue);
        return bytePlainText;
    }

    private static String generateOctetJsonWebKeyOfSize(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get("k").toString();
    }

    protected abstract String getEncryptionKeySetting();

    protected abstract String getSigningKeySetting();

    private void ensureEncryptionKeyExists(String encryptionSecretKey, int encryptionKeySize) {
        byte[] encryptionKey;
        if (StringUtils.isBlank((CharSequence)encryptionSecretKey)) {
            LOGGER.warn("Secret key for encryption is not defined under [{}]. CAS will attempt to auto-generate the encryption key", (Object)this.getEncryptionKeySetting());
            String key = new Base64RandomStringGenerator(encryptionKeySize).getNewString();
            LOGGER.warn("Generated encryption key [{}] of size [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{key, encryptionKeySize, this.getEncryptionKeySetting()});
            encryptionKey = EncodingUtils.decodeBase64(key);
        } else {
            boolean base64 = EncodingUtils.isBase64(encryptionSecretKey);
            byte[] key = new byte[]{};
            if (base64) {
                key = EncodingUtils.decodeBase64(encryptionSecretKey);
            }
            if (base64 && key.length == encryptionKeySize) {
                LOGGER.debug("Secret key for encryption defined under [{}] is Base64 encoded.", (Object)this.getEncryptionKeySetting());
                encryptionKey = key;
            } else if (encryptionSecretKey.length() != encryptionKeySize) {
                LOGGER.warn("Secret key for encryption defined under [{}] is Base64 encoded but the size does not match the key size [{}].", (Object)this.getEncryptionKeySetting(), (Object)encryptionKeySize);
                encryptionKey = encryptionSecretKey.getBytes(StandardCharsets.UTF_8);
            } else {
                LOGGER.warn("Secret key for encryption defined under [{}] is not Base64 encoded. Clear the setting to regenerate (Recommended) or replace with [{}].", (Object)this.getEncryptionKeySetting(), (Object)EncodingUtils.encodeBase64(encryptionSecretKey));
                encryptionKey = encryptionSecretKey.getBytes(StandardCharsets.UTF_8);
            }
        }
        this.encryptionSecretKey = encryptionKey;
    }

    private void ensureSigningKeyExists(String signingSecretKey, int signingKeySize) {
        String signingKeyToUse = signingSecretKey;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            LOGGER.warn("Secret key for signing is not defined under [{}]. CAS will attempt to auto-generate the signing key", (Object)this.getSigningKeySetting());
            signingKeyToUse = BaseBinaryCipherExecutor.generateOctetJsonWebKeyOfSize(signingKeySize);
            LOGGER.warn("Generated signing key [{}] of size [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{signingKeyToUse, signingKeySize, this.getSigningKeySetting()});
        }
        this.configureSigningKey(signingKeyToUse);
    }

    @Generated
    public String getCipherName() {
        return this.cipherName;
    }

    @Generated
    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    @Generated
    public byte[] getEncryptionSecretKey() {
        return this.encryptionSecretKey;
    }

    @Generated
    public SecretKeySpec getEncryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public Cipher getAesCipher() {
        return this.aesCipher;
    }

    @Generated
    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    @Generated
    public void setEncryptionSecretKey(byte[] encryptionSecretKey) {
        this.encryptionSecretKey = encryptionSecretKey;
    }
}

