/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vdurmont.semver4j.Semver;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.SpringVersion;

public final class SystemUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private static final String SEPARATOR_CHAR = "-";
    private static final int SYSTEM_INFO_DEFAULT_SIZE = 20;
    private static final String UPDATE_CHECK_MAVEN_URL = "https://search.maven.org/solrsearch/select?q=g:%22org.apereo.cas%22%20AND%20a:%22cas-server%22";

    public static Map<String, Object> getSystemInfo() {
        Properties properties = System.getProperties();
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>(20);
        info.put("CAS Version", StringUtils.defaultString((String)CasVersion.getVersion(), (String)"Not Available"));
        info.put("CAS Commit Id", StringUtils.defaultString((String)CasVersion.getSpecificationVersion(), (String)"Not Available"));
        info.put("CAS Build Date/Time", CasVersion.getDateTime());
        info.put("Spring Boot Version", SpringBootVersion.getVersion());
        info.put("Spring Version", SpringVersion.getVersion());
        info.put("Java Home", properties.get("java.home"));
        info.put("Java Vendor", properties.get("java.vendor"));
        info.put("Java Version", properties.get("java.version"));
        Runtime runtime = Runtime.getRuntime();
        info.put("JVM Free Memory", FileUtils.byteCountToDisplaySize((long)runtime.freeMemory()));
        info.put("JVM Maximum Memory", FileUtils.byteCountToDisplaySize((long)runtime.maxMemory()));
        info.put("JVM Total Memory", FileUtils.byteCountToDisplaySize((long)runtime.totalMemory()));
        info.put("JCE Installed", StringUtils.capitalize((String)BooleanUtils.toStringYesNo((boolean)EncodingUtils.isJceInstalled())));
        info.put("Node Version", SystemUtils.getNodeVersion());
        info.put("NPM Version", SystemUtils.getNpmVersion());
        info.put("OS Architecture", properties.get("os.arch"));
        info.put("OS Name", properties.get("os.name"));
        info.put("OS Version", properties.get("os.version"));
        info.put("OS Date/Time", LocalDateTime.now());
        info.put("OS Temp Directory", FileUtils.getTempDirectoryPath());
        SystemUtils.injectUpdateInfoIntoBannerIfNeeded(info);
        return info;
    }

    private static void injectUpdateInfoIntoBannerIfNeeded(Map<String, Object> info) {
        Semver latestSem;
        String currentVersion;
        Semver currentSem;
        Properties properties = System.getProperties();
        if (!properties.containsKey("CAS_UPDATE_CHECK_ENABLED")) {
            return;
        }
        URL url = new URL(UPDATE_CHECK_MAVEN_URL);
        Map results = (Map)MAPPER.readValue(url, Map.class);
        if (!results.containsKey("response")) {
            return;
        }
        Map response = (Map)results.get("response");
        if (!response.containsKey("numFound") && (Integer)response.get("numFound") != 1) {
            return;
        }
        List docs = (List)response.get("docs");
        if (docs.isEmpty()) {
            return;
        }
        Map entry = (Map)docs.get(0);
        String latestVersion = (String)entry.get("latestVersion");
        if (StringUtils.isNotBlank((CharSequence)latestVersion) && (currentSem = new Semver(currentVersion = CasVersion.getVersion())).isLowerThan(latestSem = new Semver(latestVersion))) {
            String updateString = String.format("[Latest Version: %s / Stable: %s]", latestVersion, StringUtils.capitalize((String)BooleanUtils.toStringYesNo((boolean)latestSem.isStable())));
            info.put("Update Availability", updateString);
        }
    }

    public static String getNodeVersion() {
        try {
            ProcessBuilder pb = new ProcessBuilder("node", "--version");
            Process p = pb.start();
            return IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return "N/A";
        }
    }

    public static String getNpmVersion() {
        try {
            ProcessBuilder pb = new ProcessBuilder("npm", "--version");
            Process p = pb.start();
            return IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return "N/A";
        }
    }

    @Generated
    private SystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

