/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QRUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(QRUtils.class);
    public static final int WIDTH_LARGE = 250;
    public static final int WIDTH_MEDIUM = 125;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateQRCode(OutputStream stream, String key, int width, int height) {
        EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hintMap.put(EncodeHintType.CHARACTER_SET, (Object)StandardCharsets.UTF_8.name());
        hintMap.put(EncodeHintType.MARGIN, (Object)2);
        hintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode(key, BarcodeFormat.QR_CODE, width, height, hintMap);
        int byteMatrixWidth = byteMatrix.getWidth();
        BufferedImage image = new BufferedImage(byteMatrixWidth, byteMatrixWidth, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        try {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, byteMatrixWidth, byteMatrixWidth);
            graphics.setColor(Color.BLACK);
            IntStream.range(0, byteMatrixWidth).forEach(i -> IntStream.range(0, byteMatrixWidth).filter(j -> byteMatrix.get(i, j)).forEach(j -> graphics.fillRect(i, j, 1, 1)));
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        finally {
            if (Collections.singletonList(graphics).get(0) != null) {
                graphics.dispose();
            }
        }
    }

    @Generated
    private QRUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

