/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public final class HttpUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    public static HttpResponse execute(String url, String method, String basicAuthUsername, String basicAuthPassword) {
        return HttpUtils.execute(url, method, basicAuthUsername, basicAuthPassword, new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    public static HttpResponse execute(String url, String method, String basicAuthUsername, String basicAuthPassword, Map<String, Object> headers) {
        return HttpUtils.execute(url, method, basicAuthUsername, basicAuthPassword, new HashMap<String, Object>(), headers);
    }

    public static HttpResponse execute(String url, String method) {
        return HttpUtils.execute(url, method, null, null, new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    public static HttpResponse execute(String url, String method, String basicAuthUsername, String basicAuthPassword, Map<String, Object> parameters, Map<String, Object> headers) {
        return HttpUtils.execute(url, method, basicAuthUsername, basicAuthPassword, parameters, headers, null);
    }

    public static HttpResponse execute(String url, String method, String basicAuthUsername, String basicAuthPassword, Map<String, Object> parameters, Map<String, Object> headers, String entity) {
        try {
            HttpPost request;
            HttpClient client = HttpUtils.buildHttpClient(basicAuthUsername, basicAuthPassword);
            URI uri = HttpUtils.buildHttpUri(url, parameters);
            switch (method.toLowerCase()) {
                case "post": {
                    request = new HttpPost(uri);
                    if (!StringUtils.isNotBlank((CharSequence)entity)) break;
                    StringEntity stringEntity = new StringEntity(entity);
                    request.setEntity((HttpEntity)stringEntity);
                    break;
                }
                case "delete": {
                    request = new HttpDelete(uri);
                    break;
                }
                default: {
                    request = new HttpGet(uri);
                }
            }
            headers.forEach((arg_0, arg_1) -> HttpUtils.lambda$execute$0((HttpUriRequest)request, arg_0, arg_1));
            HttpUtils.prepareHttpRequest((HttpUriRequest)request, basicAuthUsername, basicAuthPassword, parameters);
            return client.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url, String basicAuthUsername, String basicAuthPassword, Map<String, Object> parameters) {
        try {
            return HttpUtils.executeGet(url, basicAuthUsername, basicAuthPassword, parameters, new HashMap<String, Object>());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url, String basicAuthUsername, String basicAuthPassword, Map<String, Object> parameters, Map<String, Object> headers) {
        try {
            return HttpUtils.execute(url, HttpMethod.GET.name(), basicAuthUsername, basicAuthPassword, parameters, headers);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url, Map<String, Object> parameters) {
        try {
            return HttpUtils.executeGet(url, null, null, parameters);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url) {
        try {
            return HttpUtils.executeGet(url, null, null, new LinkedHashMap<String, Object>());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url, String basicAuthUsername, String basicAuthPassword) {
        try {
            return HttpUtils.executeGet(url, basicAuthUsername, basicAuthPassword, new HashMap<String, Object>());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executePost(String url, String basicAuthUsername, String basicAuthPassword, String jsonEntity) {
        return HttpUtils.executePost(url, basicAuthUsername, basicAuthPassword, jsonEntity, new HashMap<String, Object>());
    }

    public static HttpResponse executePost(String url, String jsonEntity, Map<String, Object> parameters) {
        return HttpUtils.executePost(url, null, null, jsonEntity, parameters);
    }

    public static HttpResponse executePost(String url, String basicAuthUsername, String basicAuthPassword, String jsonEntity, Map<String, Object> parameters) {
        try {
            return HttpUtils.execute(url, HttpMethod.POST.name(), basicAuthUsername, basicAuthPassword, parameters, new HashMap<String, Object>(), jsonEntity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static HttpClientBuilder prepareCredentialsIfNeeded(HttpClientBuilder builder, String basicAuthUsername, String basicAuthPassword) {
        if (StringUtils.isNotBlank((CharSequence)basicAuthUsername) && StringUtils.isNotBlank((CharSequence)basicAuthPassword)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(basicAuthUsername, basicAuthPassword);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            return builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder;
    }

    private static void prepareHttpRequest(HttpUriRequest request, String basicAuthUsername, String basicAuthPassword, Map<String, Object> parameters) {
        if (StringUtils.isNotBlank((CharSequence)basicAuthUsername) && StringUtils.isNotBlank((CharSequence)basicAuthPassword)) {
            String auth = EncodingUtils.encodeBase64(basicAuthUsername + ":" + basicAuthPassword);
            request.setHeader("Authorization", "Basic " + auth);
        }
    }

    private static URI buildHttpUri(String url, Map<String, Object> parameters) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        parameters.forEach((k, v) -> uriBuilder.addParameter(k, v.toString()));
        return uriBuilder.build();
    }

    private static HttpClient buildHttpClient(String basicAuthUsername, String basicAuthPassword) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        return HttpUtils.prepareCredentialsIfNeeded(builder, basicAuthUsername, basicAuthPassword).build();
    }

    public static HttpHeaders createBasicAuthHeaders(String basicAuthUser, String basicAuthPassword) {
        HttpHeaders acceptHeaders = new HttpHeaders();
        acceptHeaders.setAccept(CollectionUtils.wrap(MediaType.APPLICATION_JSON));
        if (StringUtils.isNotBlank((CharSequence)basicAuthUser) && StringUtils.isNotBlank((CharSequence)basicAuthPassword)) {
            String authorization = basicAuthUser + ':' + basicAuthPassword;
            String basic = EncodingUtils.encodeBase64(authorization.getBytes(Charset.forName("US-ASCII")));
            acceptHeaders.set("Authorization", "Basic " + basic);
        }
        return acceptHeaders;
    }

    @Generated
    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$execute$0(HttpUriRequest request, String k, Object v) {
        request.addHeader(k, v.toString());
    }
}

