/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.google.common.base.Splitter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpRequestUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUtils.class);
    public static final String USER_AGENT_HEADER = "user-agent";

    public static HttpServletRequest getHttpServletRequestFromRequestAttributes() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpServletResponse getHttpServletResponseFromRequestAttributes() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocation(HttpServletRequest request) {
        String geoLocationParam;
        boolean latIndex = false;
        boolean longIndex = true;
        int accuracyIndex = 2;
        int timeIndex = 3;
        GeoLocationRequest loc = new GeoLocationRequest();
        if (request != null && StringUtils.isNotBlank((CharSequence)(geoLocationParam = request.getParameter("geolocation")))) {
            List geoLocation = Splitter.on((String)",").splitToList((CharSequence)geoLocationParam);
            loc.setLatitude((String)geoLocation.get(0));
            loc.setLongitude((String)geoLocation.get(1));
            loc.setAccuracy((String)geoLocation.get(2));
            loc.setTimestamp((String)geoLocation.get(3));
        }
        return loc;
    }

    public static Map<String, String> getRequestHeaders(HttpServletRequest request) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = StringUtils.stripToEmpty((String)request.getHeader(headerName));
                headers.put(headerName, headerValue);
            }
        }
        return headers;
    }

    public static String getHttpServletRequestUserAgent(HttpServletRequest request) {
        if (request != null) {
            return request.getHeader(USER_AGENT_HEADER);
        }
        return null;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, HttpServletRequest request) {
        return argumentExtractors.stream().map(argumentExtractor -> argumentExtractor.extractService(request)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean doesParameterExist(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        if (StringUtils.isBlank((CharSequence)parameter)) {
            LOGGER.error("Missing request parameter: [{}]", (Object)name);
            return false;
        }
        LOGGER.debug("Found provided request parameter [{}]", (Object)name);
        return true;
    }
}

