/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import lombok.Generated;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodingUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodingUtils.class);
    public static final String JSON_WEB_KEY = "k";
    private static final Base32 BASE32_CHUNKED_ENCODER = new Base32(76, new byte[]{10});
    private static final Base32 BASE32_UNCHUNKED_ENCODER = new Base32(0, new byte[]{10});
    private static final Base64 BASE64_CHUNKED_ENCODER = new Base64(76, new byte[]{10});
    private static final Base64 BASE64_UNCHUNKED_ENCODER = new Base64(0, new byte[]{10});

    public static String hexDecode(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            return EncodingUtils.hexDecode(data.toCharArray());
        }
        return null;
    }

    public static String hexDecode(char[] data) {
        try {
            byte[] result = Hex.decodeHex((char[])data);
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String hexEncode(String data) {
        try {
            char[] result = Hex.encodeHex((byte[])data.getBytes(StandardCharsets.UTF_8));
            return new String(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String hexEncode(byte[] data) {
        try {
            char[] result = Hex.encodeHex((byte[])data);
            return new String(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encodeUrlSafeBase64(byte[] data) {
        return Base64.encodeBase64URLSafeString((byte[])data);
    }

    public static byte[] decodeUrlSafeBase64(String data) {
        return EncodingUtils.decodeBase64(data);
    }

    public static String encodeBase64(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    public static String encodeBase64(byte[] data, boolean chunked) {
        if (chunked) {
            return BASE64_CHUNKED_ENCODER.encodeToString(data).trim();
        }
        return BASE64_UNCHUNKED_ENCODER.encodeToString(data).trim();
    }

    public static String encodeBase64(String data) {
        return Base64.encodeBase64String((byte[])data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decodeBase64((String)data);
    }

    public static byte[] decodeBase64(byte[] data) {
        return Base64.decodeBase64((byte[])data);
    }

    public static String decodeBase64ToString(String data) {
        return new String(EncodingUtils.decodeBase64(data), StandardCharsets.UTF_8);
    }

    public static byte[] encodeBase64ToByteArray(byte[] data) {
        return Base64.encodeBase64((byte[])data);
    }

    public static String encodeBase32(byte[] data, boolean chunked) {
        if (chunked) {
            return BASE32_CHUNKED_ENCODER.encodeToString(data).trim();
        }
        return BASE32_UNCHUNKED_ENCODER.encodeToString(data).trim();
    }

    public static String urlEncode(String value) {
        return EncodingUtils.urlEncode(value, StandardCharsets.UTF_8.name());
    }

    public static String urlEncode(String value, String encoding) {
        return URLEncoder.encode(value, encoding);
    }

    public static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
    }

    public static boolean isBase64(String value) {
        return Base64.isBase64((String)value);
    }

    public static byte[] verifyJwsSignature(Key signingKey, byte[] value) {
        String asString = new String(value, StandardCharsets.UTF_8);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setCompactSerialization(asString);
        jws.setKey(signingKey);
        boolean verified = jws.verifySignature();
        if (verified) {
            String payload = jws.getEncodedPayload();
            LOGGER.trace("Successfully decoded value. Result in Base64-encoding is [{}]", (Object)payload);
            return EncodingUtils.decodeBase64(payload);
        }
        return null;
    }

    public static String generateJsonWebKey(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get(JSON_WEB_KEY).toString();
    }

    public static Key generateJsonWebKey(String secret) {
        HashMap<String, String> keys = new HashMap<String, String>(2);
        keys.put("kty", "oct");
        keys.put(JSON_WEB_KEY, secret);
        JsonWebKey jwk = JsonWebKey.Factory.newJwk(keys);
        return jwk.getKey();
    }

    public static byte[] signJwsHMACSha512(Key key, byte[] value) {
        return EncodingUtils.signJws(key, value, "HS512");
    }

    public static byte[] signJwsRSASha512(Key key, byte[] value) {
        return EncodingUtils.signJws(key, value, "RS512");
    }

    public static byte[] signJws(Key key, byte[] value, String algHeaderValue) {
        String base64 = EncodingUtils.encodeBase64(value);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setEncodedPayload(base64);
        jws.setAlgorithmHeaderValue(algHeaderValue);
        jws.setKey(key);
        return jws.getCompactSerialization().getBytes(StandardCharsets.UTF_8);
    }

    public static String encryptValueAsJwtDirectAes128Sha256(Key key, Serializable value) {
        return EncodingUtils.encryptValueAsJwt(key, value, "dir", "A128CBC-HS256");
    }

    public static String encryptValueAsJwtRsaOeap256Aes256Sha512(Key key, Serializable value) {
        return EncodingUtils.encryptValueAsJwt(key, value, "RSA-OAEP-256", "A128CBC-HS256");
    }

    public static String encryptValueAsJwt(Key secretKeyEncryptionKey, Serializable value, String algorithmHeaderValue, String contentEncryptionAlgorithmIdentifier) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(value.toString());
            jwe.enableDefaultCompression();
            jwe.setAlgorithmHeaderValue(algorithmHeaderValue);
            jwe.setEncryptionMethodHeaderParameter(contentEncryptionAlgorithmIdentifier);
            jwe.setKey(secretKeyEncryptionKey);
            LOGGER.debug("Encrypting via [{}]", (Object)contentEncryptionAlgorithmIdentifier);
            return jwe.getCompactSerialization();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Is JCE Unlimited Strength Jurisdiction Policy installed? " + e.getMessage(), e);
        }
    }

    public static String decryptJwtValue(Key secretKeyEncryptionKey, String value) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setKey(secretKeyEncryptionKey);
        jwe.setCompactSerialization(value);
        LOGGER.debug("Decrypting value...");
        return jwe.getPayload();
    }

    public static boolean isJceInstalled() {
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
            return maxKeyLen == Integer.MAX_VALUE;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Generated
    private EncodingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

