/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeUtils.class);

    public static LocalDateTime localDateTimeOf(String value) {
        LocalDate ld;
        LocalDateTime result;
        try {
            result = LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (Exception e) {
            result = null;
        }
        if (result == null) {
            try {
                result = LocalDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = LocalDateTime.parse(value);
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = LocalDateTime.parse(value.toUpperCase(), DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm a"));
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = LocalDateTime.parse(value.toUpperCase(), DateTimeFormatter.ofPattern("MM/dd/yyyy h:mm a"));
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = LocalDateTime.parse(value, DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                ld = LocalDate.parse(value, DateTimeFormatter.ofPattern("MM/dd/yyyy"));
                result = LocalDateTime.of(ld, LocalTime.now());
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                ld = LocalDate.parse(value);
                result = LocalDateTime.of(ld, LocalTime.now());
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    public static LocalDateTime localDateTimeOf(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
    }

    public static LocalDateTime localDateTimeOf(Date time) {
        return DateTimeUtils.localDateTimeOf(time.getTime());
    }

    public static ZonedDateTime zonedDateTimeOf(String value) {
        try {
            return ZonedDateTime.parse(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ZonedDateTime zonedDateTimeOf(TemporalAccessor time) {
        return ZonedDateTime.from(time);
    }

    public static ZonedDateTime zonedDateTimeOf(ReadableInstant time) {
        return DateTimeUtils.zonedDateTimeOf(time.getMillis());
    }

    public static ZonedDateTime zonedDateTimeOf(long time) {
        return DateTimeUtils.zonedDateTimeOf(time, ZoneOffset.UTC);
    }

    public static ZonedDateTime zonedDateTimeOf(long time, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId);
    }

    public static ZonedDateTime zonedDateTimeOf(Date time) {
        return DateTimeUtils.zonedDateTimeOf(time.getTime());
    }

    public static ZonedDateTime zonedDateTimeOf(Calendar time) {
        return ZonedDateTime.ofInstant(time.toInstant(), time.getTimeZone().toZoneId());
    }

    public static DateTime dateTimeOf(Instant time) {
        return new DateTime(time.toEpochMilli());
    }

    public static DateTime dateTimeOf(ChronoZonedDateTime time) {
        return DateTimeUtils.dateTimeOf(time.toInstant());
    }

    public static Date dateOf(ChronoZonedDateTime time) {
        return DateTimeUtils.dateOf(time.toInstant());
    }

    public static Date dateOf(LocalDate time) {
        return Date.from(time.atStartOfDay(ZoneOffset.UTC).toInstant());
    }

    public static Date dateOf(Instant time) {
        return Date.from(time);
    }

    public static Timestamp timestampOf(ChronoZonedDateTime time) {
        return DateTimeUtils.timestampOf(time.toInstant());
    }

    private static Timestamp timestampOf(Instant time) {
        return Timestamp.from(time);
    }

    public static TimeUnit toTimeUnit(ChronoUnit tu) {
        if (tu == null) {
            return null;
        }
        switch (tu) {
            case DAYS: {
                return TimeUnit.DAYS;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new UnsupportedOperationException("Temporal unit is not supported");
    }

    public static ChronoUnit toChronoUnit(TimeUnit tu) {
        if (tu == null) {
            return null;
        }
        switch (tu) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
        }
        return null;
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

