/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ComponentSerializationPlan;
import org.apereo.cas.ComponentSerializationPlanConfigurator;
import org.apereo.cas.util.serialization.DefaultComponentSerializationPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreUtilSerializationConfiguration")
@AutoConfigureOrder(value=-2147483648)
public class CasCoreUtilSerializationConfiguration
implements ComponentSerializationPlanConfigurator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreUtilSerializationConfiguration.class);

    @ConditionalOnMissingBean(name={"componentSerializationPlan"})
    @Autowired
    @Bean
    public ComponentSerializationPlan componentSerializationPlan(List<ComponentSerializationPlanConfigurator> configurers) {
        DefaultComponentSerializationPlan plan = new DefaultComponentSerializationPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring component serialization plan [{}]", (Object)name);
            c.configureComponentSerializationPlan((ComponentSerializationPlan)plan);
        });
        return plan;
    }
}

