/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.time.ZonedDateTime;
import javax.annotation.PostConstruct;
import javax.validation.MessageInterpolator;
import lombok.Generated;
import org.apereo.cas.CasEmbeddedValueResolver;
import org.apereo.cas.util.SchedulingUtils;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.util.io.SmsSender;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.Converters;
import org.apereo.cas.util.spring.SpringAwareMessageMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.beanvalidation.BeanValidationPostProcessor;

@Configuration(value="casCoreUtilConfiguration")
@AutoConfigureOrder(value=-2147483648)
@EnableScheduling
public class CasCoreUtilConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreUtilConfiguration.class);
    @Autowired
    @Qualifier(value="smsSender")
    private ObjectProvider<SmsSender> smsSender;
    @Autowired
    @Qualifier(value="mailSender")
    private ObjectProvider<JavaMailSender> mailSender;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public MessageInterpolator messageInterpolator() {
        return new SpringAwareMessageMessageInterpolator();
    }

    @Bean
    public CommunicationsManager communicationsManager() {
        return new CommunicationsManager((SmsSender)this.smsSender.getIfAvailable(), (JavaMailSender)this.mailSender.getIfAvailable());
    }

    @Bean
    @Role(value=2)
    @Order(value=-2147483648)
    public StringValueResolver durationCapableStringValueResolver() {
        return SchedulingUtils.prepScheduledAnnotationBeanPostProcessor((ApplicationContext)this.applicationContext);
    }

    @Bean
    public Converter<ZonedDateTime, String> zonedDateTimeToStringConverter() {
        return new Converters.ZonedDateTimeToStringConverter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"casBeanValidationPostProcessor"})
    public BeanValidationPostProcessor casBeanValidationPostProcessor() {
        return new BeanValidationPostProcessor();
    }

    @PostConstruct
    public void init() {
        ConfigurableApplicationContext ctx = this.applicationContextProvider().getConfigurableApplicationContext();
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(true);
        conversionService.setEmbeddedValueResolver((StringValueResolver)new CasEmbeddedValueResolver((ApplicationContext)ctx));
        ctx.getEnvironment().setConversionService((ConfigurableConversionService)conversionService);
        ConfigurableEnvironment env = (ConfigurableEnvironment)ctx.getParent().getEnvironment();
        env.setConversionService((ConfigurableConversionService)conversionService);
        ConverterRegistry registry = (ConverterRegistry)DefaultConversionService.getSharedInstance();
        registry.addConverter(this.zonedDateTimeToStringConverter());
    }
}

