/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vdurmont.semver4j.Semver;
import java.io.PrintStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.AsciiArtUtils;
import org.apereo.cas.util.CasVersion;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.env.Environment;

public abstract class AbstractCasBanner
implements Banner {
    private static final int SEPARATOR_REPEAT_COUNT = 60;
    private static final String UPDATE_CHECK_MAVEN_URL = "https://search.maven.org/solrsearch/select?q=g:%22org.apereo.cas%22%20AND%20a:%22cas-server%22";
    public static final String LINE_SEPARATOR = String.join((CharSequence)"", Collections.nCopies(60, "-"));
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();

    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        AsciiArtUtils.printAsciiArt(out, this.getTitle(), this.collectEnvironmentInfo(environment, sourceClass));
    }

    protected String getTitle() {
        return "(CAS)";
    }

    private String collectEnvironmentInfo(Environment environment, Class<?> sourceClass) {
        Properties properties = System.getProperties();
        if (properties.containsKey("CAS_BANNER_SKIP")) {
            try (Formatter formatter = new Formatter();){
                formatter.format("CAS Version: %s%n", CasVersion.getVersion());
                String string = formatter.toString();
                return string;
            }
        }
        try (Formatter formatter = new Formatter();){
            formatter.format("CAS Version: %s%n", StringUtils.defaultString((String)CasVersion.getVersion(), (String)"Not Available"));
            formatter.format("CAS Commit Id: %s%n", StringUtils.defaultString((String)CasVersion.getSpecificationVersion(), (String)"Not Available"));
            formatter.format("CAS Build Date/Time: %s%n", CasVersion.getDateTime());
            formatter.format("Spring Boot Version: %s%n", SpringBootVersion.getVersion());
            formatter.format("%s%n", LINE_SEPARATOR);
            formatter.format("Java Home: %s%n", properties.get("java.home"));
            formatter.format("Java Vendor: %s%n", properties.get("java.vendor"));
            formatter.format("Java Version: %s%n", properties.get("java.version"));
            Runtime runtime = Runtime.getRuntime();
            formatter.format("JVM Free Memory: %s%n", FileUtils.byteCountToDisplaySize((long)runtime.freeMemory()));
            formatter.format("JVM Maximum Memory: %s%n", FileUtils.byteCountToDisplaySize((long)runtime.maxMemory()));
            formatter.format("JVM Total Memory: %s%n", FileUtils.byteCountToDisplaySize((long)runtime.totalMemory()));
            formatter.format("JCE Installed: %s%n", StringUtils.capitalize((String)BooleanUtils.toStringYesNo((boolean)AbstractCasBanner.isJceInstalled())));
            formatter.format("%s%n", LINE_SEPARATOR);
            formatter.format("OS Architecture: %s%n", properties.get("os.arch"));
            formatter.format("OS Name: %s%n", properties.get("os.name"));
            formatter.format("OS Version: %s%n", properties.get("os.version"));
            formatter.format("OS Date/Time: %s%n", LocalDateTime.now());
            formatter.format("OS Temp Directory: %s%n", FileUtils.getTempDirectoryPath());
            formatter.format("%s%n", LINE_SEPARATOR);
            AbstractCasBanner.injectUpdateInfoIntoBannerIfNeeded(formatter);
            this.injectEnvironmentInfoIntoBanner(formatter, environment, sourceClass);
            String string = formatter.toString();
            return string;
        }
    }

    private static void injectUpdateInfoIntoBannerIfNeeded(Formatter formatter) {
        try {
            Properties properties = System.getProperties();
            if (!properties.containsKey("CAS_UPDATE_CHECK_ENABLED")) {
                return;
            }
            URL url = new URL(UPDATE_CHECK_MAVEN_URL);
            Map results = (Map)MAPPER.readValue(url, Map.class);
            if (!results.containsKey("response")) {
                return;
            }
            Map response = (Map)results.get("response");
            if (!response.containsKey("numFound") && (Integer)response.get("numFound") != 1) {
                return;
            }
            List docs = (List)response.get("docs");
            if (docs.isEmpty()) {
                return;
            }
            Map entry = (Map)docs.get(0);
            String latestVersion = (String)entry.get("latestVersion");
            if (StringUtils.isNotBlank((CharSequence)latestVersion)) {
                String currentVersion = CasVersion.getVersion();
                Semver latestSem = new Semver(latestVersion);
                Semver currentSem = new Semver(currentVersion);
                formatter.format("Update Available: %s [Latest Version: %s / Stable: %s]%n", StringUtils.capitalize((String)BooleanUtils.toStringYesNo((boolean)currentSem.isLowerThan(latestSem))), latestVersion, StringUtils.capitalize((String)BooleanUtils.toStringYesNo((boolean)latestSem.isStable())));
                formatter.format("%s%n", LINE_SEPARATOR);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void injectEnvironmentInfoIntoBanner(Formatter formatter, Environment environment, Class<?> sourceClass) {
    }

    private static boolean isJceInstalled() {
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
            return maxKeyLen == Integer.MAX_VALUE;
        }
        catch (Exception e) {
            return false;
        }
    }
}

