/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class TicketIdSanitizationUtils {
    private static final Pattern TICKET_ID_PATTERN = Pattern.compile("(TGT|PGTIOU|PGT)(-)+(\\w)+(-)+(\\w)+");
    private static final int VISIBLE_TAIL_LENGTH = 10;

    private TicketIdSanitizationUtils() {
    }

    public static String sanitize(String msg) {
        String modifiedMessage = msg;
        if (StringUtils.isNotBlank((CharSequence)msg) && !Boolean.getBoolean("CAS_TICKET_ID_SANITIZE_SKIP")) {
            Matcher matcher = TICKET_ID_PATTERN.matcher(msg);
            while (matcher.find()) {
                String match = matcher.group();
                String newId = matcher.group(1) + '-' + StringUtils.repeat((String)"*", (int)(match.length() - 10)) + StringUtils.right((String)match, (int)10);
                modifiedMessage = modifiedMessage.replaceAll(match, newId);
            }
        }
        return modifiedMessage;
    }
}

