/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathWatcherService
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathWatcherService.class);
    private static final int INTERVAL = 2000;
    private static final WatchEvent.Kind[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private Thread thread;
    private final WatchService watcher;
    private final Consumer<File> onCreate;
    private final Consumer<File> onModify;
    private final Consumer<File> onDelete;
    private final long interval;

    public PathWatcherService(File watchablePath, Consumer<File> onModify) {
        this(watchablePath.toPath(), file -> {}, onModify, file -> {}, 0L);
    }

    public PathWatcherService(File watchablePath, Consumer<File> onCreate, Consumer<File> onModify, Consumer<File> onDelete) {
        this(watchablePath.toPath(), onCreate, onModify, onDelete, 0L);
    }

    public PathWatcherService(Path watchablePath, Consumer<File> onCreate, Consumer<File> onModify, Consumer<File> onDelete) {
        this(watchablePath, onCreate, onModify, onDelete, 0L);
    }

    public PathWatcherService(Path watchablePath, Consumer<File> onCreate, Consumer<File> onModify, Consumer<File> onDelete, long intervalMilliseconds) {
        try {
            this.onCreate = onCreate;
            this.onModify = onModify;
            this.onDelete = onDelete;
            this.interval = intervalMilliseconds <= 0L ? 2000L : intervalMilliseconds;
            this.watcher = watchablePath.getFileSystem().newWatchService();
            LOGGER.debug("Created service registry watcher for events of type [{}]", (Object[])KINDS);
            watchablePath.register(this.watcher, KINDS);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        if (this.running.compareAndSet(false, true)) {
            long lastModified = System.currentTimeMillis();
            while (this.running.get()) {
                WatchKey key = null;
                try {
                    boolean valid;
                    key = this.watcher.take();
                    if (System.currentTimeMillis() - lastModified >= this.interval) {
                        this.handleEvent(key);
                        lastModified = System.currentTimeMillis();
                    }
                    if (valid = key != null && key.reset()) continue;
                }
                catch (InterruptedException e) {
                    boolean valid;
                    boolean bl = valid = key != null && key.reset();
                    if (!valid) {
                        LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                    }
                    return;
                    catch (Throwable throwable) {
                        boolean valid2;
                        boolean bl2 = valid2 = key != null && key.reset();
                        if (!valid2) {
                            LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                        }
                        throw throwable;
                    }
                }
                LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
            }
        }
    }

    private void handleEvent(WatchKey key) {
        this.readLock.lock();
        try {
            key.pollEvents().stream().filter(event -> event.count() <= 1).forEach(event -> {
                String eventName = event.kind().name();
                WatchEvent ev = event;
                Path filename = (Path)ev.context();
                Path parent = (Path)key.watchable();
                Path fullPath = parent.resolve(filename);
                File file = fullPath.toFile();
                LOGGER.trace("Detected event [{}] on file [{}]", (Object)eventName, (Object)file);
                if (eventName.equals(StandardWatchEventKinds.ENTRY_CREATE.name()) && file.exists()) {
                    this.onCreate.accept(file);
                } else if (eventName.equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                    this.onDelete.accept(file);
                } else if (eventName.equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) && file.exists()) {
                    this.onModify.accept(file);
                }
            });
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.watcher);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void start(String name) {
        try {
            this.thread = new Thread(this);
            this.thread.setName(name);
            this.thread.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

