/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class CopyServletOutputStream
extends ServletOutputStream {
    private static final int BUFFER_SIZE = 1024;
    private final OutputStream outputStream;
    private final ByteArrayOutputStream copy;

    public CopyServletOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.copy = new ByteArrayOutputStream(1024);
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.copy.write(b);
    }

    public byte[] getCopy() {
        return this.copy.toByteArray();
    }

    public String getStringCopy() {
        return new String(this.getCopy(), StandardCharsets.UTF_8);
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

