/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.AesCipherService;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBinaryCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBinaryCipherExecutor.class);
    protected final String cipherName;
    private String secretKeyAlgorithm = "AES";
    private byte[] encryptionSecretKey;

    public BaseBinaryCipherExecutor(String encryptionSecretKey, String signingSecretKey, int signingKeySize, int encryptionKeySize, String cipherName) {
        this.cipherName = cipherName;
        this.ensureSigningKeyExists(signingSecretKey, signingKeySize);
        this.ensureEncryptionKeyExists(encryptionSecretKey, encryptionKeySize);
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public byte[] encode(byte[] value) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.encryptionSecretKey, this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.encrypt(value, key.getEncoded()).getBytes();
            return this.sign(result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] decode(byte[] value) {
        try {
            byte[] verifiedValue = this.verifySignature(value);
            SecretKeySpec key = new SecretKeySpec(this.encryptionSecretKey, this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            return cipher.decrypt(verifiedValue, key.getEncoded()).getBytes();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String generateOctetJsonWebKeyOfSize(int size) {
        try {
            OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
            Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
            return params.get("k").toString();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getName() {
        return null;
    }

    protected abstract String getEncryptionKeySetting();

    protected abstract String getSigningKeySetting();

    private void ensureEncryptionKeyExists(String encryptionSecretKey, int encryptionKeySize) {
        byte[] encryptionKey;
        if (StringUtils.isBlank((CharSequence)encryptionSecretKey)) {
            LOGGER.warn("Secret key for encryption is not defined under [{}]. CAS will attempt to auto-generate the encryption key", (Object)this.getEncryptionKeySetting());
            String key = new Base64RandomStringGenerator(encryptionKeySize).getNewString();
            LOGGER.warn("Generated encryption key [{}] of size [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{key, encryptionKeySize, this.getEncryptionKeySetting()});
            encryptionKey = EncodingUtils.decodeBase64(key);
        } else {
            boolean base64 = EncodingUtils.isBase64(encryptionSecretKey);
            byte[] key = new byte[]{};
            if (base64) {
                key = EncodingUtils.decodeBase64(encryptionSecretKey);
            }
            if (base64 && key.length == encryptionKeySize) {
                LOGGER.debug("Secret key for encryption defined under [{}] is Base64 encoded.", (Object)this.getEncryptionKeySetting());
                encryptionKey = key;
            } else if (encryptionSecretKey.length() != encryptionKeySize) {
                LOGGER.warn("Secret key for encryption defined under [{}] is Base64 encoded but the size does not match the key size [{}].", (Object)this.getEncryptionKeySetting(), (Object)encryptionKeySize);
                encryptionKey = encryptionSecretKey.getBytes(StandardCharsets.UTF_8);
            } else {
                LOGGER.warn("Secret key for encryption defined under [{}] is not Base64 encoded. Clear the setting to regenerate (Recommended) or replace with [{}].", (Object)this.getEncryptionKeySetting(), (Object)EncodingUtils.encodeBase64(encryptionSecretKey));
                encryptionKey = encryptionSecretKey.getBytes(StandardCharsets.UTF_8);
            }
        }
        this.encryptionSecretKey = encryptionKey;
    }

    private void ensureSigningKeyExists(String signingSecretKey, int signingKeySize) {
        String signingKeyToUse = signingSecretKey;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            LOGGER.warn("Secret key for signing is not defined under [{}]. CAS will attempt to auto-generate the signing key", (Object)this.getSigningKeySetting());
            signingKeyToUse = BaseBinaryCipherExecutor.generateOctetJsonWebKeyOfSize(signingKeySize);
            LOGGER.warn("Generated signing key [{}] of size [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{signingKeyToUse, signingKeySize, this.getSigningKeySetting()});
        }
        this.setSigningKey(signingKeyToUse);
    }
}

