/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;

public class Base64CipherExecutor
extends AbstractCipherExecutor<Serializable, String> {
    private static CipherExecutor<Serializable, String> INSTANCE;

    protected Base64CipherExecutor() {
    }

    public static CipherExecutor<Serializable, String> getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Base64CipherExecutor();
        }
        return INSTANCE;
    }

    public String encode(Serializable value) {
        return EncodingUtils.encodeBase64(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    public String decode(Serializable value) {
        byte[] decoded = EncodingUtils.decodeBase64(value.toString());
        return new String(decoded, StandardCharsets.UTF_8);
    }

    public String getName() {
        return null;
    }
}

