/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public final class ScriptingUtils {
    private static final Pattern INLINE_GROOVY_PATTERN = RegexUtils.createPattern("groovy\\s*\\{(.+)\\}");
    private static final Pattern FILE_GROOVY_PATTERN = RegexUtils.createPattern("file:(.+\\.groovy)");
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingUtils.class);

    private ScriptingUtils() {
    }

    public static boolean isInlineGroovyScript(String script) {
        return ScriptingUtils.getMatcherForInlineGroovyScript(script).find();
    }

    public static boolean isExternalGroovyScript(String script) {
        return ScriptingUtils.getMatcherForExternalGroovyScript(script).find();
    }

    public static Matcher getMatcherForInlineGroovyScript(String script) {
        return INLINE_GROOVY_PATTERN.matcher(script);
    }

    public static Matcher getMatcherForExternalGroovyScript(String script) {
        return FILE_GROOVY_PATTERN.matcher(script);
    }

    public static <T> T executeGroovyShellScript(String script, Map<String, Object> variables) {
        try {
            Binding binding = new Binding();
            GroovyShell shell = new GroovyShell(binding);
            if (variables != null && !variables.isEmpty()) {
                variables.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
            }
            if (!binding.hasVariable("logger")) {
                binding.setVariable("logger", (Object)LOGGER);
            }
            LOGGER.debug("Executing groovy script [{}] with variables [{}]", (Object)script, (Object)binding.getVariables());
            return (T)shell.evaluate(script);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T executeGroovyScript(Resource groovyScript, Object[] args, Class<T> clazz) {
        return ScriptingUtils.executeGroovyScript(groovyScript, "run", args, clazz);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Class<T> clazz, Object ... args) {
        return ScriptingUtils.executeGroovyScript(groovyScript, methodName, args, clazz);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Class<T> clazz) {
        return ScriptingUtils.executeGroovyScript(groovyScript, methodName, new Object[0], clazz);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Object[] args, Class<T> clazz) {
        if (groovyScript == null || StringUtils.isBlank((CharSequence)methodName)) {
            return null;
        }
        ClassLoader parent = ScriptingUtils.class.getClassLoader();
        return (T)AccessController.doPrivileged(() -> ScriptingUtils.getGroovyResult(groovyScript, methodName, args, clazz, parent));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T getGroovyResult(Resource groovyScript, String methodName, Object[] args, Class<T> clazz, ClassLoader parent) {
        try (GroovyClassLoader loader = new GroovyClassLoader(parent);){
            File groovyFile = groovyScript.getFile();
            if (groovyFile.exists()) {
                Class groovyClass = loader.parseClass(groovyFile);
                LOGGER.trace("Creating groovy object instance from class [{}]", (Object)groovyFile.getCanonicalPath());
                GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
                LOGGER.trace("Executing groovy script's [{}] method, with parameters [{}]", (Object)methodName, (Object)args);
                Object result = groovyObject.invokeMethod(methodName, (Object)args);
                LOGGER.trace("Results returned by the groovy script are [{}]", result);
                if (result != null && !clazz.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
                }
                Object object = result;
                return (T)object;
            }
            LOGGER.trace("Groovy script at [{}] does not exist", (Object)groovyScript);
            return null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> T executeGroovyScriptEngine(String scriptFile, Object[] args) {
        try {
            String engineName = ScriptingUtils.getScriptEngineName(scriptFile);
            ScriptEngine engine = new ScriptEngineManager().getEngineByName(engineName);
            if (engine == null || StringUtils.isBlank((CharSequence)engineName)) {
                LOGGER.warn("Script engine is not available for [{}]", (Object)engineName);
                return null;
            }
            AbstractResource resourceFrom = ResourceUtils.getResourceFrom(scriptFile);
            File theScriptFile = resourceFrom.getFile();
            if (theScriptFile.exists()) {
                LOGGER.debug("Created object instance from class [{}]", (Object)theScriptFile.getCanonicalPath());
                engine.eval(new FileReader(theScriptFile));
                Invocable invocable = (Invocable)((Object)engine);
                LOGGER.debug("Executing script's run method, with parameters [{}]", args);
                Object result = invocable.invokeFunction("run", args);
                LOGGER.debug("Groovy script result is [{}]", result);
                return (T)result;
            }
            LOGGER.warn("[{}] script [{}] does not exist, or cannot be loaded", (Object)StringUtils.capitalize((String)engineName), (Object)scriptFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> T executeGroovyScriptEngine(String script, Map<String, Object> variables) {
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("groovy");
            if (engine == null) {
                LOGGER.warn("Script engine is not available for Groovy");
                return null;
            }
            SimpleBindings binding = new SimpleBindings();
            if (variables != null && !variables.isEmpty()) {
                binding.putAll((Map<? extends String, ? extends Object>)variables);
            }
            if (!binding.containsKey("logger")) {
                binding.put("logger", (Object)LOGGER);
            }
            return (T)engine.eval(script, (Bindings)binding);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getScriptEngineName(String scriptFile) {
        String engineName = null;
        if (scriptFile.endsWith(".py")) {
            engineName = "python";
        } else if (scriptFile.endsWith(".js")) {
            engineName = "js";
        } else if (scriptFile.endsWith(".groovy")) {
            engineName = "groovy";
        }
        return engineName;
    }
}

