/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;

public final class ResourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String HTTP_URL_PREFIX = "http";

    private ResourceUtils() {
    }

    public static AbstractResource getRawResourceFrom(String location) throws IOException {
        if (StringUtils.isBlank((CharSequence)location)) {
            throw new IllegalArgumentException("Provided location does not exist and is empty");
        }
        Object res = location.toLowerCase().startsWith(HTTP_URL_PREFIX) ? new UrlResource(location) : (location.toLowerCase().startsWith("classpath:") ? new ClassPathResource(location.substring("classpath:".length())) : new FileSystemResource(StringUtils.remove((String)location, (String)"file:")));
        return res;
    }

    public static boolean doesResourceExist(String resource, ResourceLoader resourceLoader) {
        try {
            if (StringUtils.isNotBlank((CharSequence)resource)) {
                Resource res = resourceLoader.getResource(resource);
                return ResourceUtils.doesResourceExist(res);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean doesResourceExist(Resource res) {
        if (res != null) {
            try {
                IOUtils.read((InputStream)res.getInputStream(), (byte[])new byte[1]);
                return res.contentLength() > 0L;
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean doesResourceExist(String location) {
        try {
            return ResourceUtils.getResourceFrom(location) != null;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static AbstractResource getResourceFrom(String location) throws IOException {
        AbstractResource metadataLocationResource = ResourceUtils.getRawResourceFrom(location);
        if (!metadataLocationResource.exists() || !metadataLocationResource.isReadable()) {
            throw new FileNotFoundException("Resource " + location + " does not exist or is unreadable");
        }
        return metadataLocationResource;
    }

    public static Resource prepareClasspathResourceIfNeeded(Resource resource) {
        if (resource == null) {
            LOGGER.debug("No resource defined to prepare. Returning null");
            return null;
        }
        return ResourceUtils.prepareClasspathResourceIfNeeded(resource, false, resource.getFilename());
    }

    public static Resource prepareClasspathResourceIfNeeded(Resource resource, boolean isDirectory, String containsName) {
        try {
            if (resource == null) {
                LOGGER.debug("No resource defined to prepare. Returning null");
                return null;
            }
            if (!ClassUtils.isAssignable(resource.getClass(), ClassPathResource.class)) {
                return resource;
            }
            if (org.springframework.util.ResourceUtils.isFileURL((URL)resource.getURL())) {
                return resource;
            }
            URL url = org.springframework.util.ResourceUtils.extractArchiveURL((URL)resource.getURL());
            File file = org.springframework.util.ResourceUtils.getFile((URL)url);
            File casDirectory = new File(FileUtils.getTempDirectory(), "cas");
            File destination = new File(casDirectory, resource.getFilename());
            if (isDirectory) {
                FileUtils.forceMkdir((File)destination);
                FileUtils.cleanDirectory((File)destination);
            } else if (destination.exists()) {
                FileUtils.forceDelete((File)destination);
            }
            try (JarFile jFile = new JarFile(file);){
                Enumeration<JarEntry> e = jFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().contains(resource.getFilename()) || !entry.getName().contains(containsName)) continue;
                    InputStream stream = jFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        File copyDestination = destination;
                        if (isDirectory) {
                            File entryFileName = new File(entry.getName());
                            copyDestination = new File(destination, entryFileName.getName());
                        }
                        FileWriter writer = new FileWriter(copyDestination);
                        Throwable throwable2 = null;
                        try {
                            IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (writer == null) continue;
                            if (throwable2 != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            writer.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            return new FileSystemResource(destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean isFile(String resource) {
        return StringUtils.isNotBlank((CharSequence)resource) && resource.startsWith("file:");
    }
}

