/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexUtils {
    public static final Pattern MATCH_NOTHING_PATTERN = Pattern.compile("a^");
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexUtils.class);

    private RegexUtils() {
    }

    public static boolean isValidRegex(String pattern) {
        try {
            if (pattern != null) {
                Pattern.compile(pattern);
                return true;
            }
        }
        catch (PatternSyntaxException exception) {
            LOGGER.debug("Pattern [{}] is not a valid regex.", (Object)pattern);
        }
        return false;
    }

    public static Pattern concatenate(Collection<String> requiredValues, boolean caseInsensitive) {
        String pattern = requiredValues.stream().collect(Collectors.joining("|", "(", ")"));
        return RegexUtils.createPattern(pattern, caseInsensitive ? 2 : 0);
    }

    public static Pattern createPattern(String pattern) {
        return RegexUtils.createPattern(pattern, 2);
    }

    private static Pattern createPattern(String pattern, int flags) {
        if (pattern == null) {
            LOGGER.debug("Pattern cannot be null");
            return MATCH_NOTHING_PATTERN;
        }
        try {
            return Pattern.compile(pattern, flags);
        }
        catch (PatternSyntaxException exception) {
            LOGGER.debug("Pattern [{}] is not a valid regex.", (Object)pattern);
            return MATCH_NOTHING_PATTERN;
        }
    }

    public static boolean matches(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    public static boolean find(Pattern pattern, String string) {
        return pattern.matcher(string).find();
    }

    public static boolean find(String pattern, String string) {
        return RegexUtils.createPattern(pattern, 2).matcher(string).find();
    }
}

