/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;

public final class Pac4jUtils {
    private Pac4jUtils() {
    }

    public static String getPac4jAuthenticatedUsername() {
        String id;
        ProfileManager manager;
        Optional profile;
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
        if (request != null && response != null && (profile = (manager = Pac4jUtils.getPac4jProfileManager(request, response)).get(true)) != null && profile.isPresent() && (id = ((UserProfile)profile.get()).getId()) != null) {
            return id;
        }
        return "audit:unknown";
    }

    public static ProfileManager getPac4jProfileManager(HttpServletRequest request, HttpServletResponse response) {
        J2EContext context = Pac4jUtils.getPac4jJ2EContext(request, response);
        return Pac4jUtils.getPac4jProfileManager((WebContext)context);
    }

    public static ProfileManager getPac4jProfileManager(WebContext context) {
        return new ProfileManager(context);
    }

    public static J2EContext getPac4jJ2EContext(HttpServletRequest request, HttpServletResponse response) {
        return new J2EContext(request, response);
    }

    public static J2EContext getPac4jJ2EContext() {
        return Pac4jUtils.getPac4jJ2EContext(HttpRequestUtils.getHttpServletRequestFromRequestAttributes(), HttpRequestUtils.getHttpServletResponseFromRequestAttributes());
    }
}

