/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.net.InetAddress;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InetAddressUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InetAddressUtils.class);

    private InetAddressUtils() {
    }

    public static String getByName(String urlAddr) {
        try {
            URL url = new URL(urlAddr);
            return InetAddress.getByName(url.getHost()).getHostAddress();
        }
        catch (Exception e) {
            LOGGER.debug("Host name could not be determined automatically.", (Throwable)e);
            return null;
        }
    }

    public static String getCasServerHostName() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            int index = hostName.indexOf(46);
            if (index > 0) {
                return hostName.substring(0, index);
            }
            return hostName;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Host name could not be determined automatically.", e);
        }
    }
}

