/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public final class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static HttpResponse execute(String url, String method, String basicAuthUsername, String basicAuthPassword) {
        return HttpUtils.execute(url, method, basicAuthUsername, basicAuthPassword, new HashMap<String, String>());
    }

    public static HttpResponse execute(String url, String method, String basicAuthUsername, String basicAuthPassword, Map<String, String> parameters) {
        try {
            HttpClient client = HttpUtils.buildHttpClient(basicAuthUsername, basicAuthPassword);
            URI uri = HttpUtils.buildHttpUri(url, parameters);
            HttpGet request = method.equalsIgnoreCase(HttpMethod.GET.name()) ? new HttpGet(uri) : new HttpPost(uri);
            return client.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static URI buildHttpUri(String url, Map<String, String> parameters) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        parameters.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
        return uriBuilder.build();
    }

    private static HttpClient buildHttpClient(String basicAuthUsername, String basicAuthPassword) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        HttpUtils.prepareCredentialsIfNeeded(builder, basicAuthUsername, basicAuthPassword);
        return builder.build();
    }

    public static HttpResponse executeGet(String url, String basicAuthUsername, String basicAuthPassword, Map<String, String> parameters) {
        try {
            return HttpUtils.execute(url, HttpMethod.GET.name(), basicAuthUsername, basicAuthPassword, parameters);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url, Map<String, String> parameters) {
        try {
            return HttpUtils.executeGet(url, null, null, parameters);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executeGet(String url, String basicAuthUsername, String basicAuthPassword) {
        try {
            return HttpUtils.executeGet(url, basicAuthUsername, basicAuthPassword, new HashMap<String, String>());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executePost(String url, String basicAuthUsername, String basicAuthPassword, Map<String, String> parameters) {
        try {
            return HttpUtils.execute(url, basicAuthPassword, basicAuthUsername, HttpMethod.POST.name(), parameters);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executePost(String url, String basicAuthUsername, String basicAuthPassword, HttpEntity entity) {
        try {
            HttpClient client = HttpUtils.buildHttpClient(basicAuthUsername, basicAuthPassword);
            URI uri = HttpUtils.buildHttpUri(url, new HashMap<String, String>());
            HttpPost request = new HttpPost(uri);
            request.setEntity(entity);
            return client.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executePost(String url, HttpEntity entity, Map<String, String> parameters) {
        try {
            HttpClient client = HttpUtils.buildHttpClient(null, null);
            URI uri = HttpUtils.buildHttpUri(url, parameters);
            HttpPost request = new HttpPost(uri);
            request.setEntity(entity);
            return client.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpResponse executePost(String url, String basicAuthUsername, String basicAuthPassword, String jsonEntity) {
        return HttpUtils.executePost(url, basicAuthUsername, basicAuthPassword, jsonEntity, new HashMap<String, String>());
    }

    public static HttpResponse executePost(String url, String jsonEntity, Map<String, String> parameters) {
        return HttpUtils.executePost(url, null, null, jsonEntity, parameters);
    }

    public static HttpResponse executePost(String url, String basicAuthUsername, String basicAuthPassword, String jsonEntity, Map<String, String> parameters) {
        try {
            HttpClient client = HttpUtils.buildHttpClient(basicAuthUsername, basicAuthPassword);
            URI uri = HttpUtils.buildHttpUri(url, parameters);
            HttpPost request = new HttpPost(uri);
            StringEntity entity = new StringEntity(jsonEntity, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)entity);
            return client.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void prepareCredentialsIfNeeded(HttpClientBuilder builder, String basicAuthUsername, String basicAuthPassword) {
        if (StringUtils.isNotBlank((CharSequence)basicAuthUsername) && StringUtils.isNotBlank((CharSequence)basicAuthPassword)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(basicAuthUsername, basicAuthPassword);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
    }
}

