/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.time.ZonedDateTime;
import javax.annotation.PostConstruct;
import javax.validation.MessageInterpolator;
import org.apereo.cas.config.support.CasConfigurationEmbeddedValueResolver;
import org.apereo.cas.util.SchedulingUtils;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.Converters;
import org.apereo.cas.util.spring.CustomBeanValidationPostProcessor;
import org.apereo.cas.util.spring.SpringAwareMessageMessageInterpolator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.StringValueResolver;

@Configuration(value="casCoreUtilConfiguration")
@AutoConfigureOrder(value=-2147483648)
@EnableScheduling
public class CasCoreUtilConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public MessageInterpolator messageInterpolator() {
        return new SpringAwareMessageMessageInterpolator();
    }

    @Bean
    public CommunicationsManager communicationsManager() {
        return new CommunicationsManager();
    }

    @Bean
    @Role(value=2)
    @Order(value=-2147483648)
    public StringValueResolver durationCapableStringValueResolver() {
        return SchedulingUtils.prepScheduledAnnotationBeanPostProcessor(this.applicationContext);
    }

    @Bean
    public Converter<ZonedDateTime, String> zonedDateTimeToStringConverter() {
        return new Converters.ZonedDateTimeToStringConverter();
    }

    @Bean
    public CustomBeanValidationPostProcessor beanValidationPostProcessor() {
        return new CustomBeanValidationPostProcessor();
    }

    @PostConstruct
    public void init() {
        ConfigurableApplicationContext ctx = this.applicationContextProvider().getConfigurableApplicationContext();
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(true);
        conversionService.setEmbeddedValueResolver((StringValueResolver)new CasConfigurationEmbeddedValueResolver((ApplicationContext)ctx));
        ctx.getEnvironment().setConversionService((ConfigurableConversionService)conversionService);
        ConfigurableEnvironment env = (ConfigurableEnvironment)ctx.getParent().getEnvironment();
        env.setConversionService((ConfigurableConversionService)conversionService);
        ConverterRegistry registry = (ConverterRegistry)DefaultConversionService.getSharedInstance();
        registry.addConverter(this.zonedDateTimeToStringConverter());
    }
}

