/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.MessageDescriptor;
import org.springframework.util.Assert;

public class DefaultMessageDescriptor
implements MessageDescriptor {
    private static final long serialVersionUID = 1227390629186486032L;
    private final String code;
    private final String defaultMessage;
    private final Serializable[] params;

    public DefaultMessageDescriptor(String code) {
        this(code, code, new Serializable[0]);
    }

    public DefaultMessageDescriptor(String code, String defaultMessage, Serializable ... params) {
        Assert.hasText((String)code, (String)"Code cannot be null or empty");
        Assert.hasText((String)defaultMessage, (String)"Default message cannot be null or empty");
        this.code = code;
        this.defaultMessage = defaultMessage;
        this.params = params;
    }

    public String getCode() {
        return this.code;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Serializable[] getParams() {
        if (this.params == null) {
            return null;
        }
        return Arrays.copyOf(this.params, this.params.length);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(99, 31);
        builder.append((Object)this.code);
        builder.append((Object)this.defaultMessage);
        builder.append((Object[])this.params);
        return builder.toHashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DefaultMessageDescriptor)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        DefaultMessageDescriptor m = (DefaultMessageDescriptor)other;
        return this.code.equals(m.getCode()) && this.defaultMessage.equals(m.getDefaultMessage()) && Arrays.equals(this.params, m.getParams());
    }
}

