/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public abstract class BaseDelegatingExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatingExpirationPolicy.class);
    private static final long serialVersionUID = 5927936344949518688L;
    private final Map<String, ExpirationPolicy> policies = new LinkedHashMap<String, ExpirationPolicy>();
    private final ExpirationPolicy defaultExpirationPolicy;

    public BaseDelegatingExpirationPolicy(ExpirationPolicy defaultExpirationPolicy) {
        this.defaultExpirationPolicy = defaultExpirationPolicy;
    }

    public void addPolicy(ExpirationPolicy policy) {
        LOGGER.debug("Adding expiration policy [{}] with name [{}]", (Object)policy, (Object)policy.getName());
        this.policies.put(policy.getName(), policy);
    }

    public void addPolicy(String name, ExpirationPolicy policy) {
        LOGGER.debug("Adding expiration policy [{}] with name [{}]", (Object)policy, (Object)name);
        this.policies.put(name, policy);
    }

    public void addPolicy(Enum name, ExpirationPolicy policy) {
        LOGGER.debug("Adding expiration policy [{}] with name [{}]", (Object)policy, (Object)name);
        this.addPolicy(name.name(), policy);
    }

    @Override
    public boolean isExpired(TicketState ticketState) {
        Optional<ExpirationPolicy> match = this.getExpirationPolicyFor(ticketState);
        if (!match.isPresent()) {
            LOGGER.warn("No expiration policy was found for ticket state [{}]. Consider configuring a predicate that delegates to an expiration policy.", (Object)ticketState);
            return super.isExpired(ticketState);
        }
        ExpirationPolicy policy = match.get();
        LOGGER.debug("Activating expiration policy [{}] for ticket [{}]", (Object)policy, (Object)ticketState);
        return policy.isExpired(ticketState);
    }

    public Long getTimeToLive(TicketState ticketState) {
        Optional<ExpirationPolicy> match = this.getExpirationPolicyFor(ticketState);
        if (!match.isPresent()) {
            LOGGER.warn("No expiration policy was found for ticket state [{}]. Consider configuring a predicate that delegates to an expiration policy.", (Object)ticketState);
            return super.getTimeToLive(ticketState);
        }
        ExpirationPolicy policy = match.get();
        LOGGER.debug("Getting TTL from policy [{}] for ticket [{}]", (Object)policy, (Object)ticketState);
        return policy.getTimeToLive(ticketState);
    }

    @JsonIgnore
    public Long getTimeToLive() {
        if (this.defaultExpirationPolicy == null) {
            return 0L;
        }
        return this.defaultExpirationPolicy.getTimeToLive();
    }

    @JsonIgnore
    public Long getTimeToIdle() {
        if (this.defaultExpirationPolicy == null) {
            return 0L;
        }
        return this.defaultExpirationPolicy.getTimeToIdle();
    }

    protected Optional<ExpirationPolicy> getExpirationPolicyFor(TicketState ticketState) {
        String name = this.getExpirationPolicyNameFor(ticketState);
        LOGGER.debug("Received expiration policy name [{}] to activate", (Object)name);
        if (StringUtils.isNotBlank((CharSequence)name) && this.policies.containsKey(name)) {
            ExpirationPolicy policy = this.policies.get(name);
            LOGGER.debug("Located expiration policy [{}] by name [{}]", (Object)policy, (Object)name);
            return Optional.of(policy);
        }
        LOGGER.warn("No expiration policy could be found by the name [{}] for ticket state [{}]", (Object)name, (Object)ticketState);
        return Optional.empty();
    }

    protected abstract String getExpirationPolicyNameFor(TicketState var1);

    @Generated
    public Map<String, ExpirationPolicy> getPolicies() {
        return this.policies;
    }

    @Generated
    public ExpirationPolicy getDefaultExpirationPolicy() {
        return this.defaultExpirationPolicy;
    }

    @Generated
    public BaseDelegatingExpirationPolicy() {
        this.defaultExpirationPolicy = null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDelegatingExpirationPolicy)) {
            return false;
        }
        BaseDelegatingExpirationPolicy other = (BaseDelegatingExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, ExpirationPolicy> this$policies = this.policies;
        Map<String, ExpirationPolicy> other$policies = other.policies;
        if (this$policies == null ? other$policies != null : !((Object)this$policies).equals(other$policies)) {
            return false;
        }
        ExpirationPolicy this$defaultExpirationPolicy = this.defaultExpirationPolicy;
        ExpirationPolicy other$defaultExpirationPolicy = other.defaultExpirationPolicy;
        return !(this$defaultExpirationPolicy == null ? other$defaultExpirationPolicy != null : !this$defaultExpirationPolicy.equals(other$defaultExpirationPolicy));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseDelegatingExpirationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, ExpirationPolicy> $policies = this.policies;
        result = result * 59 + ($policies == null ? 43 : ((Object)$policies).hashCode());
        ExpirationPolicy $defaultExpirationPolicy = this.defaultExpirationPolicy;
        result = result * 59 + ($defaultExpirationPolicy == null ? 43 : $defaultExpirationPolicy.hashCode());
        return result;
    }
}

