/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodedTicket
implements Ticket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodedTicket.class);
    private static final long serialVersionUID = -7078771807487764116L;
    private String id;
    private byte[] encodedTicket;

    @JsonCreator
    public EncodedTicket(@JsonProperty(value="encoded") String encodedTicket, @JsonProperty(value="id") String encodedTicketId) {
        this.id = encodedTicketId;
        this.encodedTicket = EncodingUtils.decodeBase64((String)encodedTicket);
    }

    @JsonIgnore
    public int getCountOfUses() {
        LOGGER.trace("[Retrieving ticket usage count]");
        return 0;
    }

    private String getOpNotSupportedMessage(String op) {
        return op + " operation not supported on a " + this.getClass().getSimpleName() + ". Ticket must be decoded first";
    }

    @JsonIgnore
    public ExpirationPolicy getExpirationPolicy() {
        LOGGER.trace(this.getOpNotSupportedMessage("[Retrieving expiration policy]"));
        return null;
    }

    @JsonIgnore
    public String getPrefix() {
        return "";
    }

    public ZonedDateTime getCreationTime() {
        LOGGER.trace(this.getOpNotSupportedMessage("[Retrieving ticket creation time]"));
        return null;
    }

    public TicketGrantingTicket getTicketGrantingTicket() {
        LOGGER.trace(this.getOpNotSupportedMessage("[Retrieving parent ticket-granting ticket]"));
        return null;
    }

    @JsonIgnore
    public boolean isExpired() {
        LOGGER.trace(this.getOpNotSupportedMessage("[Ticket expiry checking]"));
        return false;
    }

    @JsonIgnore
    public void markTicketExpired() {
    }

    public int compareTo(Ticket o) {
        return this.getId().compareTo(o.getId());
    }

    @Generated
    public String toString() {
        return "EncodedTicket(id=" + this.id + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public byte[] getEncodedTicket() {
        return this.encodedTicket;
    }

    @Generated
    public EncodedTicket() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncodedTicket)) {
            return false;
        }
        EncodedTicket other = (EncodedTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EncodedTicket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public EncodedTicket(String id, byte[] encodedTicket) {
        this.id = id;
        this.encodedTicket = encodedTicket;
    }
}

