/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DefaultTicketRegistrySupport
implements TicketRegistrySupport {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketRegistrySupport.class);
    private final TicketRegistry ticketRegistry;

    public Authentication getAuthenticationFrom(String ticketGrantingTicketId) throws RuntimeException {
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        return tgt == null || tgt.isExpired() ? null : tgt.getAuthentication();
    }

    public Principal getAuthenticatedPrincipalFrom(String ticketGrantingTicketId) throws RuntimeException {
        Authentication auth = this.getAuthenticationFrom(ticketGrantingTicketId);
        return auth == null ? null : auth.getPrincipal();
    }

    public Map<String, Object> getPrincipalAttributesFrom(String ticketGrantingTicketId) throws RuntimeException {
        Principal principal = this.getAuthenticatedPrincipalFrom(ticketGrantingTicketId);
        return principal == null ? null : principal.getAttributes();
    }

    public void updateAuthentication(String ticketGrantingTicketId, Authentication authentication) {
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        tgt.getAuthentication().update(authentication);
        this.ticketRegistry.updateTicket((Ticket)tgt);
    }

    @Generated
    public DefaultTicketRegistrySupport(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

