/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapBasedTicketRegistry
extends AbstractTicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMapBasedTicketRegistry.class);

    public AbstractMapBasedTicketRegistry(CipherExecutor cipherExecutor) {
        this.setCipherExecutor(cipherExecutor);
    }

    public void addTicket(@NonNull Ticket ticket) {
        if (ticket == null) {
            throw new NullPointerException("ticket is marked @NonNull but is null");
        }
        Ticket encTicket = this.encodeTicket(ticket);
        LOGGER.debug("Added ticket [{}] to registry.", (Object)ticket.getId());
        this.getMapInstance().put(encTicket.getId(), encTicket);
    }

    public Ticket getTicket(String ticketId) {
        String encTicketId = this.encodeTicketId(ticketId);
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            return null;
        }
        Ticket found = this.getMapInstance().get(encTicketId);
        if (found == null) {
            LOGGER.debug("Ticket  [{}] could not be found", (Object)encTicketId);
            return null;
        }
        Ticket result = this.decodeTicket(found);
        if (result != null && result.isExpired()) {
            LOGGER.debug("Ticket [{}] has expired and is now removed from the cache", (Object)result.getId());
            this.getMapInstance().remove(encTicketId);
            return null;
        }
        return result;
    }

    @Override
    public boolean deleteSingleTicket(String ticketId) {
        String encTicketId = this.encodeTicketId(ticketId);
        if (StringUtils.isBlank((CharSequence)encTicketId)) {
            return false;
        }
        return this.getMapInstance().remove(encTicketId) != null;
    }

    public long deleteAll() {
        int size = this.getMapInstance().size();
        this.getMapInstance().clear();
        return size;
    }

    public Collection<Ticket> getTickets() {
        return this.decodeTickets(this.getMapInstance().values());
    }

    public Ticket updateTicket(Ticket ticket) {
        this.addTicket(ticket);
        return ticket;
    }

    public abstract Map<String, Ticket> getMapInstance();

    @Generated
    public AbstractMapBasedTicketRegistry() {
    }
}

