/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceTicketFactory
implements ServiceTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceTicketFactory.class);
    private final ExpirationPolicy serviceTicketExpirationPolicy;
    private final Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    private final boolean trackMostRecentSession;
    private final CipherExecutor<String, String> cipherExecutor;
    private final UniqueTicketIdGenerator defaultServiceTicketIdGenerator = new DefaultUniqueTicketIdGenerator();

    public <T extends Ticket> T create(TicketGrantingTicket ticketGrantingTicket, Service service, boolean credentialProvided, Class<T> clazz) {
        String ticketId = this.produceTicketIdentifier(service, ticketGrantingTicket, credentialProvided);
        if (this.cipherExecutor != null) {
            LOGGER.debug("Attempting to encode service ticket [{}]", (Object)ticketId);
            ticketId = (String)this.cipherExecutor.encode((Object)ticketId);
            LOGGER.debug("Encoded service ticket id [{}]", (Object)ticketId);
        }
        return this.produceTicket(ticketGrantingTicket, service, credentialProvided, ticketId, clazz);
    }

    protected <T extends Ticket> T produceTicket(TicketGrantingTicket ticketGrantingTicket, Service service, boolean credentialProvided, String ticketId, Class<T> clazz) {
        ServiceTicket result = ticketGrantingTicket.grantServiceTicket(ticketId, service, this.serviceTicketExpirationPolicy, credentialProvided, this.trackMostRecentSession);
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
        }
        return (T)result;
    }

    protected String produceTicketIdentifier(Service service, TicketGrantingTicket ticketGrantingTicket, boolean credentialProvided) {
        String uniqueTicketIdGenKey = service.getClass().getName();
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = null;
        if (this.uniqueTicketIdGeneratorsForService != null && !this.uniqueTicketIdGeneratorsForService.isEmpty()) {
            LOGGER.debug("Looking up service ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
            serviceTicketUniqueTicketIdGenerator = this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        }
        if (serviceTicketUniqueTicketIdGenerator == null) {
            serviceTicketUniqueTicketIdGenerator = this.defaultServiceTicketIdGenerator;
            LOGGER.debug("Service ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        return serviceTicketUniqueTicketIdGenerator.getNewTicketId("ST");
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }

    @Generated
    public DefaultServiceTicketFactory(ExpirationPolicy serviceTicketExpirationPolicy, Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService, boolean trackMostRecentSession, CipherExecutor<String, String> cipherExecutor) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
        this.trackMostRecentSession = trackMostRecentSession;
        this.cipherExecutor = cipherExecutor;
    }
}

