/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyTicketFactory
implements ProxyTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProxyTicketFactory.class);
    private final UniqueTicketIdGenerator defaultTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    private final Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    private final ExpirationPolicy proxyTicketExpirationPolicy;
    private final CipherExecutor<String, String> cipherExecutor;
    private final boolean onlyTrackMostRecentSession;

    public DefaultProxyTicketFactory(ExpirationPolicy expirationPolicy, Map<String, UniqueTicketIdGenerator> ticketIdGenerators, CipherExecutor<String, String> cipherExecutor, boolean onlyTrackMostRecentSession) {
        this.proxyTicketExpirationPolicy = expirationPolicy;
        this.uniqueTicketIdGeneratorsForService = ticketIdGenerators;
        this.cipherExecutor = cipherExecutor;
        this.onlyTrackMostRecentSession = onlyTrackMostRecentSession;
    }

    public <T extends Ticket> T create(ProxyGrantingTicket proxyGrantingTicket, Service service, Class<T> clazz) {
        String ticketId = this.produceTicketIdentifier(service);
        return this.produceTicket(proxyGrantingTicket, service, ticketId, clazz);
    }

    protected <T extends Ticket> T produceTicket(ProxyGrantingTicket proxyGrantingTicket, Service service, String ticketId, Class<T> clazz) {
        ProxyTicket result = proxyGrantingTicket.grantProxyTicket(ticketId, service, this.proxyTicketExpirationPolicy, this.onlyTrackMostRecentSession);
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
        }
        return (T)result;
    }

    protected String produceTicketIdentifier(Service service) {
        String uniqueTicketIdGenKey = service.getClass().getName();
        LOGGER.debug("Looking up ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
        UniqueTicketIdGenerator generator = this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        if (generator == null) {
            generator = this.defaultTicketIdGenerator;
            LOGGER.debug("Ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        String ticketId = generator.getNewTicketId("PT");
        if (this.cipherExecutor != null) {
            LOGGER.debug("Attempting to encode proxy ticket [{}]", (Object)ticketId);
            ticketId = (String)this.cipherExecutor.encode((Object)ticketId);
            LOGGER.debug("Encoded proxy ticket id [{}]", (Object)ticketId);
        }
        return ticketId;
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }
}

