/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;

public class DefaultTicketCatalog
implements TicketCatalog {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketCatalog.class);
    private final Map<String, TicketDefinition> ticketMetadataMap = new HashMap<String, TicketDefinition>();

    public TicketDefinition find(String ticketId) {
        TicketDefinition defn = this.ticketMetadataMap.values().stream().filter(md -> ticketId.startsWith(md.getPrefix())).findFirst().orElse(null);
        if (defn == null) {
            LOGGER.error("Ticket definition for [{}] cannot be found in the ticket catalog which only contains the following ticket types: [{}]", (Object)ticketId, this.ticketMetadataMap.keySet());
        }
        return defn;
    }

    public TicketDefinition find(Ticket ticket) {
        LOGGER.debug("Locating ticket definition for ticket [{}]", (Object)ticket);
        return this.find(ticket.getPrefix());
    }

    public Collection<TicketDefinition> find(Class<Ticket> ticketClass) {
        List<TicketDefinition> list = this.ticketMetadataMap.values().stream().filter(t -> t.getImplementationClass().isAssignableFrom(ticketClass)).collect(Collectors.toList());
        OrderComparator.sort(list);
        LOGGER.debug("Located all registered and known sorted ticket definitions [{}] that match [{}]", list, ticketClass);
        return list;
    }

    public void register(TicketDefinition ticketDefinition) {
        LOGGER.debug("Registering/Updating ticket definition [{}]", (Object)ticketDefinition);
        this.ticketMetadataMap.put(ticketDefinition.getPrefix(), ticketDefinition);
    }

    public void update(TicketDefinition metadata) {
        this.register(metadata);
    }

    public boolean contains(String ticketId) {
        LOGGER.debug("Locating ticket definition for [{}]", (Object)ticketId);
        return this.ticketMetadataMap.containsKey(ticketId);
    }

    public Collection<TicketDefinition> findAll() {
        ArrayList<TicketDefinition> list = new ArrayList<TicketDefinition>(this.ticketMetadataMap.values());
        OrderComparator.sort(list);
        LOGGER.debug("Located all registered and known sorted ticket definitions [{}]", list);
        return list;
    }

    @Generated
    public DefaultTicketCatalog() {
    }
}

