/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.registry.EncodedTicket;
import org.apereo.cas.util.serialization.AbstractJacksonBackedStringSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTicketSerializers {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTicketSerializers.class);
    private static final Map<String, Class> TICKET_TYPE_CACHE = new ConcurrentHashMap<String, Class>();
    private static final PrettyPrinter MINIMAL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    private static final StringSerializer<ProxyGrantingTicket> PROXY_GRANTING_TICKET_SERIALIZER = new AbstractJacksonBackedStringSerializer<ProxyGrantingTicket>(MINIMAL_PRETTY_PRINTER){
        private static final long serialVersionUID = 7089208351327601379L;

        protected Class<ProxyGrantingTicket> getTypeToSerialize() {
            return ProxyGrantingTicket.class;
        }
    };
    private static final StringSerializer<ProxyTicket> PROXY_TICKET_SERIALIZER = new AbstractJacksonBackedStringSerializer<ProxyTicket>(MINIMAL_PRETTY_PRINTER){
        private static final long serialVersionUID = -6343596853082798477L;

        protected Class<ProxyTicket> getTypeToSerialize() {
            return ProxyTicket.class;
        }
    };
    private static final StringSerializer<TicketGrantingTicket> TICKET_GRANTING_TICKET_SERIALIZER = new AbstractJacksonBackedStringSerializer<TicketGrantingTicket>(MINIMAL_PRETTY_PRINTER){
        private static final long serialVersionUID = 1527874389457723545L;

        protected Class<TicketGrantingTicket> getTypeToSerialize() {
            return TicketGrantingTicket.class;
        }
    };
    private static final StringSerializer<ServiceTicket> SERVICE_TICKET_SERIALIZER = new AbstractJacksonBackedStringSerializer<ServiceTicket>(MINIMAL_PRETTY_PRINTER){
        private static final long serialVersionUID = 8959617299162115085L;

        protected Class<ServiceTicket> getTypeToSerialize() {
            return ServiceTicket.class;
        }
    };
    private static final StringSerializer<EncodedTicket> ENCODED_TICKET_SERIALIZER = new AbstractJacksonBackedStringSerializer<EncodedTicket>(MINIMAL_PRETTY_PRINTER){
        private static final long serialVersionUID = 8959835299162115085L;

        protected Class<EncodedTicket> getTypeToSerialize() {
            return EncodedTicket.class;
        }
    };

    public static StringSerializer<ProxyGrantingTicket> getProxyGrantingTicketSerializer() {
        return PROXY_GRANTING_TICKET_SERIALIZER;
    }

    public static StringSerializer<ProxyTicket> getProxyTicketSerializer() {
        return PROXY_TICKET_SERIALIZER;
    }

    public static StringSerializer<TicketGrantingTicket> getTicketGrantingTicketSerializer() {
        return TICKET_GRANTING_TICKET_SERIALIZER;
    }

    public static StringSerializer<ServiceTicket> getServiceTicketSerializer() {
        return SERVICE_TICKET_SERIALIZER;
    }

    public static StringSerializer<EncodedTicket> getEncodedTicketSerializer() {
        return ENCODED_TICKET_SERIALIZER;
    }

    public static String serializeTicket(Ticket ticket) {
        StringWriter writer = new StringWriter();
        if (ticket instanceof TicketGrantingTicket) {
            BaseTicketSerializers.getTicketGrantingTicketSerializer().to((Writer)writer, (Object)((TicketGrantingTicket)TicketGrantingTicket.class.cast(ticket)));
        } else if (ticket instanceof ServiceTicket) {
            BaseTicketSerializers.getServiceTicketSerializer().to((Writer)writer, (Object)((ServiceTicket)ServiceTicket.class.cast(ticket)));
        } else if (ticket instanceof EncodedTicket) {
            BaseTicketSerializers.getEncodedTicketSerializer().to((Writer)writer, (Object)((EncodedTicket)EncodedTicket.class.cast(ticket)));
        } else {
            LOGGER.warn("Could not find serializer to marshal ticket [{}]. Ticket type may not be supported.", (Object)ticket.getId());
        }
        return writer.toString();
    }

    public static Ticket deserializeTicket(String ticketContent, String type) {
        Class clazz;
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new InvalidTicketException("Invalid ticket type [blank] specified");
        }
        if (TICKET_TYPE_CACHE.containsKey(type)) {
            clazz = TICKET_TYPE_CACHE.get(type);
        } else {
            clazz = Class.forName(type);
            TICKET_TYPE_CACHE.put(type, clazz);
        }
        return BaseTicketSerializers.deserializeTicket(ticketContent, clazz);
    }

    public static <T extends Ticket> T deserializeTicket(String ticketContent, Class<T> clazz) {
        Ticket ticket = null;
        if (TicketGrantingTicket.class.isAssignableFrom(clazz)) {
            ticket = (Ticket)BaseTicketSerializers.getTicketGrantingTicketSerializer().from(ticketContent);
        } else if (ServiceTicket.class.isAssignableFrom(clazz)) {
            ticket = (Ticket)BaseTicketSerializers.getServiceTicketSerializer().from(ticketContent);
        } else if (EncodedTicket.class.isAssignableFrom(clazz)) {
            ticket = (Ticket)BaseTicketSerializers.getEncodedTicketSerializer().from(ticketContent);
        }
        if (ticket == null) {
            throw new InvalidTicketException(clazz.getName());
        }
        if (!clazz.isAssignableFrom(ticket.getClass())) {
            throw new ClassCastException("Ticket [" + ticket.getId() + " is of type " + ticket.getClass() + " when we were expecting " + clazz);
        }
        return (T)ticket;
    }
}

