/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceFactory<T extends Service>
implements ServiceFactory<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceFactory.class);

    public <T extends Service> T createService(String id, Class<T> clazz) {
        Service service = this.createService(id);
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Service [" + service.getId() + " is of type " + service.getClass() + " when we were expecting " + clazz);
        }
        return (T)service;
    }

    public <T extends Service> T createService(HttpServletRequest request, Class<T> clazz) {
        Service service = this.createService(request);
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Service [" + service.getId() + " is of type " + service.getClass() + " when we were expecting " + clazz);
        }
        return (T)service;
    }

    protected static String cleanupUrl(String url) {
        if (url == null) {
            return null;
        }
        int jsessionPosition = url.indexOf(";jsession");
        if (jsessionPosition == -1) {
            return url;
        }
        int questionMarkPosition = url.indexOf(63);
        if (questionMarkPosition < jsessionPosition) {
            return url.substring(0, url.indexOf(";jsession"));
        }
        return url.substring(0, jsessionPosition) + url.substring(questionMarkPosition);
    }

    protected static String getSourceParameter(HttpServletRequest request, String ... paramNames) {
        if (request != null) {
            Map parameterMap = request.getParameterMap();
            String param = Stream.of(paramNames).filter(p -> parameterMap.containsKey(p) || request.getAttribute(p) != null).findFirst().orElse(null);
            return param;
        }
        return null;
    }

    @Generated
    public String toString() {
        return "AbstractServiceFactory()";
    }
}

