/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.support;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.support.AbstractProtocolAttributeEncoder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.DefaultRegisteredServiceCipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasProtocolAttributeEncoder
extends AbstractProtocolAttributeEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasProtocolAttributeEncoder.class);
    private final CipherExecutor<String, String> cacheCredentialCipherExecutor;

    public DefaultCasProtocolAttributeEncoder(ServicesManager servicesManager, CipherExecutor cacheCredentialCipherExecutor) {
        this(servicesManager, (RegisteredServiceCipherExecutor)new DefaultRegisteredServiceCipherExecutor(), cacheCredentialCipherExecutor);
    }

    public DefaultCasProtocolAttributeEncoder(ServicesManager servicesManager, RegisteredServiceCipherExecutor cipherExecutor, CipherExecutor cacheCredentialCipherExecutor) {
        super(servicesManager, cipherExecutor);
        this.cacheCredentialCipherExecutor = cacheCredentialCipherExecutor;
    }

    protected void encodeAndEncryptCredentialPassword(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        if (cachedAttributesToEncode.containsKey("credential")) {
            String value = cachedAttributesToEncode.get("credential");
            String decodedValue = (String)this.cacheCredentialCipherExecutor.decode((Object)value);
            cachedAttributesToEncode.remove("credential");
            if (StringUtils.isNotBlank((CharSequence)decodedValue)) {
                cachedAttributesToEncode.put("credential", decodedValue);
            }
        }
        this.encryptAndEncodeAndPutIntoAttributesMap(attributes, cachedAttributesToEncode, "credential", cipher, registeredService);
    }

    protected void encodeAndEncryptProxyGrantingTicket(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        this.encryptAndEncodeAndPutIntoAttributesMap(attributes, cachedAttributesToEncode, "proxyGrantingTicket", cipher, registeredService);
    }

    protected void encryptAndEncodeAndPutIntoAttributesMap(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, String cachedAttributeName, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        String cachedAttribute = cachedAttributesToEncode.remove(cachedAttributeName);
        if (StringUtils.isNotBlank((CharSequence)cachedAttribute)) {
            LOGGER.debug("Retrieved [{}] as a cached model attribute...", (Object)cachedAttributeName);
            String encodedValue = cipher.encode(cachedAttribute, registeredService);
            if (StringUtils.isNotBlank((CharSequence)encodedValue)) {
                attributes.put(cachedAttributeName, encodedValue);
                LOGGER.debug("Encrypted and encoded [{}] as an attribute to [{}].", (Object)cachedAttributeName, (Object)encodedValue);
            } else {
                LOGGER.warn("Attribute [{}] cannot be encoded and is removed from the collection of attributes", (Object)cachedAttributeName);
            }
        } else {
            LOGGER.debug("[{}] is not available as a cached model attribute to encrypt...", (Object)cachedAttributeName);
        }
    }

    @Override
    protected void encodeAttributesInternal(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        this.encodeAndEncryptCredentialPassword(attributes, cachedAttributesToEncode, cipher, registeredService);
        this.encodeAndEncryptProxyGrantingTicket(attributes, cachedAttributesToEncode, cipher, registeredService);
        DefaultCasProtocolAttributeEncoder.sanitizeAndTransformAttributeNames(attributes, registeredService);
    }

    private static void sanitizeAndTransformAttributeNames(Map<String, Object> attributes, RegisteredService registeredService) {
        LOGGER.debug("Sanitizing attribute names in preparation of the final validation response");
        Set<Pair> attrs = attributes.keySet().stream().filter(DefaultCasProtocolAttributeEncoder.getSanitizingAttributeNamePredicate()).map(s -> Pair.of((Object)EncodingUtils.hexEncode((byte[])s.getBytes(StandardCharsets.UTF_8)), attributes.get(s))).collect(Collectors.toSet());
        if (!attrs.isEmpty()) {
            LOGGER.warn("Found [{}] attribute(s) that need to be sanitized/encoded.", attrs);
            attributes.keySet().removeIf(DefaultCasProtocolAttributeEncoder.getSanitizingAttributeNamePredicate());
            attrs.forEach(p -> {
                LOGGER.debug("Sanitized attribute name to be [{}]", p.getKey());
                attributes.put((String)p.getKey(), p.getValue());
            });
        }
    }

    private static Predicate<String> getSanitizingAttributeNamePredicate() {
        return s -> s.contains(":") || s.contains("@");
    }
}

