/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.DefaultRegisteredServiceCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolAttributeEncoder
implements ProtocolAttributeEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProtocolAttributeEncoder.class);
    protected ServicesManager servicesManager;
    private RegisteredServiceCipherExecutor cipherExecutor;

    public AbstractProtocolAttributeEncoder(ServicesManager servicesManager) {
        this(servicesManager, (RegisteredServiceCipherExecutor)new DefaultRegisteredServiceCipherExecutor());
    }

    public AbstractProtocolAttributeEncoder(ServicesManager servicesManager, RegisteredServiceCipherExecutor cipherExecutor) {
        this.servicesManager = servicesManager;
        this.cipherExecutor = cipherExecutor;
    }

    public Map<String, Object> encodeAttributes(Map<String, Object> attributes, RegisteredService registeredService) {
        LOGGER.debug("Starting to encode attributes for release to service [{}]", (Object)registeredService);
        HashMap<String, Object> newEncodedAttributes = new HashMap<String, Object>(attributes);
        Map<String, String> cachedAttributesToEncode = this.initialize(newEncodedAttributes);
        if (registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            this.encodeAttributesInternal(newEncodedAttributes, cachedAttributesToEncode, this.cipherExecutor, registeredService);
            LOGGER.debug("[{}] encoded attributes are available for release to [{}]: [{}]", new Object[]{newEncodedAttributes.size(), registeredService, newEncodedAttributes.keySet()});
        } else {
            LOGGER.debug("Service [{}] is not found/enabled in the service registry so no encoding has taken place.", (Object)registeredService);
        }
        return newEncodedAttributes;
    }

    protected abstract void encodeAttributesInternal(Map<String, Object> var1, Map<String, String> var2, RegisteredServiceCipherExecutor var3, RegisteredService var4);

    protected Map<String, String> initialize(Map<String, Object> attributes) {
        HashMap<String, String> cachedAttributesToEncode = new HashMap<String, String>(attributes.size());
        String messageFormat = "Removed [{}] as an authentication attribute and cached it locally.";
        Collection collection = (Collection)attributes.remove("credential");
        if (collection != null && collection.size() == 1) {
            cachedAttributesToEncode.put("credential", collection.iterator().next().toString());
            LOGGER.debug("Removed [{}] as an authentication attribute and cached it locally.", (Object)"credential");
        }
        if ((collection = (Collection)attributes.remove("proxyGrantingTicket")) != null && collection.size() == 1) {
            cachedAttributesToEncode.put("proxyGrantingTicket", collection.iterator().next().toString());
            LOGGER.debug("Removed [{}] as an authentication attribute and cached it locally.", (Object)"proxyGrantingTicket");
        }
        return cachedAttributesToEncode;
    }

    public void setCipherExecutor(RegisteredServiceCipherExecutor cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }
}

