/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.AbstractWebApplicationServiceResponseBuilder;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.springframework.util.StringUtils;

public class WebApplicationServiceResponseBuilder
extends AbstractWebApplicationServiceResponseBuilder {
    private static final long serialVersionUID = -851233878780818494L;

    public Response build(WebApplicationService service, String serviceTicketId, Authentication authentication) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.hasText((String)serviceTicketId)) {
            parameters.put("ticket", serviceTicketId);
        }
        WebApplicationService finalService = this.buildInternal(service, parameters);
        Response.ResponseType responseType = this.getWebApplicationServiceResponseType();
        if (responseType == Response.ResponseType.POST) {
            return this.buildPost(finalService, parameters);
        }
        if (responseType == Response.ResponseType.REDIRECT) {
            return this.buildRedirect(finalService, parameters);
        }
        if (responseType == Response.ResponseType.HEADER) {
            return this.buildHeader(finalService, parameters);
        }
        throw new IllegalArgumentException("Response type is valid. Only POST/REDIRECT are supported");
    }

    protected WebApplicationService buildInternal(WebApplicationService service, Map<String, String> parameters) {
        return service;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return new EqualsBuilder().appendSuper(super.equals(obj)).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).toHashCode();
    }

    public boolean supports(WebApplicationService service) {
        return true;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

